/*
 * Decompiled with CFR 0.152.
 */
package lombok.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.core.LombokApp;
import lombok.core.SpiLoadUtil;
import lombok.core.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private static final Collection<?> HELP_SWITCHES = Collections.unmodifiableList(Arrays.asList("/?", "/h", "/help", "-h", "-help", "--help", "help", "h"));
    private final List<LombokApp> apps;
    private final List<String> args;

    public static void main(String[] args) throws IOException {
        int err = new Main(SpiLoadUtil.readAllFromIterator(SpiLoadUtil.findServices(LombokApp.class)), Arrays.asList(args)).go();
        System.exit(err);
    }

    public Main(List<LombokApp> apps, List<String> args) {
        this.apps = apps;
        this.args = args;
    }

    public int go() {
        String command;
        if (!this.args.isEmpty() && HELP_SWITCHES.contains(this.args.get(0))) {
            this.printHelp(null, System.out);
            return 0;
        }
        String string = command = this.args.isEmpty() ? "" : this.args.get(0).trim();
        if (command.startsWith("--")) {
            command = command.substring(2);
        } else if (command.startsWith("-")) {
            command = command.substring(1);
        }
        List<String> subArgs = this.args.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(this.args.subList(1, this.args.size()));
        for (LombokApp app : this.apps) {
            if (!app.getAppName().equals(command) && !app.getAppAliases().contains(command)) continue;
            try {
                return app.runApp(subArgs);
            }
            catch (Exception e) {
                e.printStackTrace();
                return 5;
            }
        }
        this.printHelp("Unknown command: " + command, System.err);
        return 1;
    }

    public void printHelp(String message, PrintStream out) {
        if (message != null) {
            out.println(message);
            out.println("------------------------------");
        }
        out.println("projectlombok.org v" + Version.getVersion());
        out.println("Copyright (C) 2009 Reinier Zwitserloot and Roel Spilker.");
        out.println("Run 'lombok license' to see the lombok license agreement.");
        out.println();
        out.println("Run lombok without any parameters to start the graphical installer.");
        out.println("Other available commands:");
        for (LombokApp app : this.apps) {
            String[] desc = app.getAppDescription().split("\n");
            for (int i = 0; i < desc.length; ++i) {
                out.printf("  %15s    %s\n", i == 0 ? app.getAppName() : "", desc[i]);
            }
        }
        out.println();
        out.println("Run lombok commandName --help for more info on each command.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LicenseApp
    implements LombokApp {
        @Override
        public String getAppName() {
            return "license";
        }

        @Override
        public String getAppDescription() {
            return "prints license information.";
        }

        @Override
        public List<String> getAppAliases() {
            return Arrays.asList("license", "licence", "copyright", "copyleft", "gpl");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int runApp(List<String> args) {
            int n;
            InputStream in = Main.class.getResourceAsStream("/LICENCE");
            try {
                int r;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] b = new byte[65536];
                while ((r = in.read(b)) != -1) {
                    out.write(b, 0, r);
                }
                System.out.println(new String(out.toByteArray()));
                n = 0;
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    throw throwable;
                }
                catch (Exception e) {
                    System.err.println("License file not found. Check http://projectlombok.org/LICENCE");
                    return 1;
                }
            }
            in.close();
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VersionApp
    implements LombokApp {
        @Override
        public String getAppName() {
            return "version";
        }

        @Override
        public String getAppDescription() {
            return "prints lombok's version.";
        }

        @Override
        public List<String> getAppAliases() {
            return Arrays.asList("version", "-version", "--version");
        }

        @Override
        public int runApp(List<String> args) {
            System.out.println(Version.getVersion());
            return 0;
        }
    }
}

