/*
 * Decompiled with CFR 0.152.
 */
package lombok.core.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationsUtil {
    private static final List<String> KNOWN_BOOLEAN_PREFIXES = Collections.unmodifiableList(Arrays.asList("is", "has", "get"));
    public static final Pattern PRIMITIVE_TYPE_NAME_PATTERN = Pattern.compile("^(boolean|byte|short|int|long|float|double|char)$");
    public static final Pattern NON_NULL_PATTERN = Pattern.compile("^nonnull$", 2);
    public static final Pattern NULLABLE_PATTERN = Pattern.compile("^nullable$", 2);

    private TransformationsUtil() {
    }

    public static String toGetterName(CharSequence fieldName, boolean isBoolean) {
        String prefix;
        String string = prefix = isBoolean ? "is" : "get";
        if (fieldName.length() == 0) {
            return prefix;
        }
        for (String knownBooleanPrefix : KNOWN_BOOLEAN_PREFIXES) {
            if (!((Object)fieldName).toString().startsWith(knownBooleanPrefix) || fieldName.length() <= knownBooleanPrefix.length() || Character.isLowerCase(fieldName.charAt(knownBooleanPrefix.length()))) continue;
            return ((Object)fieldName).toString();
        }
        return TransformationsUtil.buildName(prefix, ((Object)fieldName).toString());
    }

    public static String toSetterName(CharSequence fieldName) {
        return TransformationsUtil.buildName("set", ((Object)fieldName).toString());
    }

    private static String buildName(String prefix, String suffix) {
        if (suffix.length() == 0) {
            return prefix;
        }
        char first = suffix.charAt(0);
        if (Character.isLowerCase(first)) {
            boolean useUpperCase = suffix.length() > 2 && (Character.isTitleCase(suffix.charAt(1)) || Character.isUpperCase(suffix.charAt(1)));
            suffix = String.format("%s%s", Character.valueOf(useUpperCase ? Character.toUpperCase(first) : Character.toTitleCase(first)), suffix.subSequence(1, suffix.length()));
        }
        return String.format("%s%s", prefix, suffix);
    }

    public static List<String> toAllGetterNames(CharSequence fieldName, boolean isBoolean) {
        if (!isBoolean) {
            return Collections.singletonList(TransformationsUtil.toGetterName(fieldName, false));
        }
        ArrayList<String> baseNames = new ArrayList<String>();
        baseNames.add(((Object)fieldName).toString());
        for (String knownBooleanPrefix : KNOWN_BOOLEAN_PREFIXES) {
            if (!((Object)fieldName).toString().startsWith(knownBooleanPrefix) || fieldName.length() <= knownBooleanPrefix.length() || Character.isLowerCase(fieldName.charAt(knownBooleanPrefix.length()))) continue;
            baseNames.add(((Object)fieldName).toString().substring(knownBooleanPrefix.length()));
        }
        HashSet<String> names = new HashSet<String>();
        for (String baseName : baseNames) {
            if (baseName.length() > 0 && Character.isLowerCase(baseName.charAt(0))) {
                baseName = Character.toTitleCase(baseName.charAt(0)) + baseName.substring(1);
            }
            for (String prefix : KNOWN_BOOLEAN_PREFIXES) {
                names.add(prefix + baseName);
            }
        }
        return new ArrayList<String>(names);
    }
}

