/*
 * Decompiled with CFR 0.152.
 */
package lombok.installer.eclipse;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.installer.CorruptedIdeLocationException;
import lombok.installer.IdeFinder;
import lombok.installer.IdeLocation;
import lombok.installer.eclipse.EclipseLocationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseFinder
extends IdeFinder {
    protected String getDirName() {
        return "eclipse";
    }

    protected String getWindowsExecutableName() {
        return "eclipse.exe";
    }

    protected String getUnixExecutableName() {
        return "eclipse";
    }

    protected String getMacExecutableName() {
        return "Eclipse.app";
    }

    protected IdeLocation createLocation(String guess) throws CorruptedIdeLocationException {
        return new EclipseLocationProvider().create0(guess);
    }

    protected List<String> getSourceDirsOnWindows() {
        return Arrays.asList("\\", "\\Program Files", System.getProperty("user.home", "."));
    }

    protected List<String> getSourceDirsOnMac() {
        return Arrays.asList("/Applications", System.getProperty("user.home", "."));
    }

    protected List<String> getSourceDirsOnUnix() {
        return Arrays.asList(System.getProperty("user.home", "."));
    }

    private void findEclipseOnWindows(List<IdeLocation> locations, List<CorruptedIdeLocationException> problems) {
        List<String> driveLetters = Arrays.asList("C");
        try {
            driveLetters = EclipseFinder.getDrivesOnWindows();
        }
        catch (Throwable ignore) {
            ignore.printStackTrace();
        }
        for (String letter : driveLetters) {
            for (String possibleSource : this.getSourceDirsOnWindows()) {
                try {
                    File f = new File(letter + ":" + possibleSource);
                    if (!f.isDirectory()) continue;
                    for (File dir : f.listFiles()) {
                        if (!dir.isDirectory()) continue;
                        try {
                            String eclipseLocation;
                            if (!dir.getName().toLowerCase().contains(this.getDirName()) || (eclipseLocation = this.findEclipseOnWindows1(dir)) == null) continue;
                            try {
                                locations.add(this.createLocation(eclipseLocation));
                            }
                            catch (CorruptedIdeLocationException e) {
                                problems.add(e);
                            }
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception ignore) {
                }
            }
        }
    }

    private String findEclipseOnWindows1(File dir) {
        if (new File(dir, this.getWindowsExecutableName()).isFile()) {
            return dir.getAbsolutePath();
        }
        return null;
    }

    @Override
    public void findIdes(List<IdeLocation> locations, List<CorruptedIdeLocationException> problems) {
        switch (EclipseFinder.getOS()) {
            case WINDOWS: {
                this.findEclipseOnWindows(locations, problems);
                break;
            }
            case MAC_OS_X: {
                this.findEclipseOnMac(locations, problems);
                break;
            }
            default: {
                this.findEclipseOnUnix(locations, problems);
            }
        }
    }

    private void findEclipseOnUnix(List<IdeLocation> locations, List<CorruptedIdeLocationException> problems) {
        ArrayList<String> guesses = new ArrayList<String>();
        File d = new File("/usr/bin/" + this.getUnixExecutableName());
        if (d.exists()) {
            guesses.add(d.getPath());
        }
        if ((d = new File("/usr/local/bin/" + this.getUnixExecutableName())).exists()) {
            guesses.add(d.getPath());
        }
        if ((d = new File(System.getProperty("user.home", "."), "bin/" + this.getUnixExecutableName())).exists()) {
            guesses.add(d.getPath());
        }
        this.findEclipseOnUnix1("/usr/local/share", guesses);
        this.findEclipseOnUnix1("/usr/local", guesses);
        this.findEclipseOnUnix1("/usr/share", guesses);
        for (String possibleSourceDir : this.getSourceDirsOnUnix()) {
            this.findEclipseOnUnix1(possibleSourceDir, guesses);
        }
        for (String guess : guesses) {
            try {
                locations.add(this.createLocation(guess));
            }
            catch (CorruptedIdeLocationException e) {
                problems.add(e);
            }
        }
    }

    private void findEclipseOnUnix1(String dir, List<String> guesses) {
        File d = new File(dir);
        if (!d.isDirectory()) {
            return;
        }
        for (File f : d.listFiles()) {
            File possible;
            if (!f.isDirectory() || !f.getName().toLowerCase().contains(this.getDirName()) || !(possible = new File(f, this.getUnixExecutableName())).exists()) continue;
            guesses.add(possible.getAbsolutePath());
        }
    }

    private void findEclipseOnMac(List<IdeLocation> locations, List<CorruptedIdeLocationException> problems) {
        for (String possibleSourceDir : this.getSourceDirsOnMac()) {
            File[] list = new File(possibleSourceDir).listFiles();
            if (list == null) continue;
            for (File dir : list) {
                this.findEclipseOnMac1(dir, locations, problems);
            }
        }
    }

    private void findEclipseOnMac1(File f, List<IdeLocation> locations, List<CorruptedIdeLocationException> problems) {
        if (!f.isDirectory()) {
            return;
        }
        if (f.getName().toLowerCase().equals(this.getMacExecutableName().toLowerCase())) {
            try {
                locations.add(this.createLocation(f.getParent()));
            }
            catch (CorruptedIdeLocationException e) {
                problems.add(e);
            }
        }
        if (f.getName().toLowerCase().contains(this.getDirName()) && new File(f, this.getMacExecutableName()).exists()) {
            try {
                locations.add(this.createLocation(f.toString()));
            }
            catch (CorruptedIdeLocationException e) {
                problems.add(e);
            }
        }
    }
}

