/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.util.ArrayList;
import javax.annotation.processing.Messager;
import lombok.javac.HandlerLibrary;
import lombok.javac.JavacAST;
import lombok.javac.JavacASTAdapter;
import lombok.javac.JavacNode;

public class JavacTransformer {
    private final HandlerLibrary handlers;
    private final Messager messager;

    public JavacTransformer(Messager messager) {
        this.messager = messager;
        this.handlers = HandlerLibrary.load(messager);
    }

    public boolean transform(Context context, Iterable<JCTree.JCCompilationUnit> compilationUnits) {
        ArrayList<JavacAST> asts = new ArrayList<JavacAST>();
        for (JCTree.JCCompilationUnit unit : compilationUnits) {
            asts.add(new JavacAST(this.messager, context, unit));
        }
        this.handlers.skipPrintAST();
        for (JavacAST ast : asts) {
            ast.traverse(new AnnotationVisitor());
            this.handlers.callASTVisitors(ast);
        }
        this.handlers.skipAllButPrintAST();
        for (JavacAST ast : asts) {
            ast.traverse(new AnnotationVisitor());
        }
        for (JavacAST ast : asts) {
            if (!ast.isChanged()) continue;
            return true;
        }
        return false;
    }

    private class AnnotationVisitor
    extends JavacASTAdapter {
        private AnnotationVisitor() {
        }

        @Override
        public void visitAnnotationOnType(JCTree.JCClassDecl type, JavacNode annotationNode, JCTree.JCAnnotation annotation) {
            if (annotationNode.isHandled()) {
                return;
            }
            JCTree.JCCompilationUnit top = (JCTree.JCCompilationUnit)((JavacNode)annotationNode.top()).get();
            boolean handled = JavacTransformer.this.handlers.handleAnnotation(top, annotationNode, annotation);
            if (handled) {
                annotationNode.setHandled();
            }
        }

        @Override
        public void visitAnnotationOnField(JCTree.JCVariableDecl field, JavacNode annotationNode, JCTree.JCAnnotation annotation) {
            if (annotationNode.isHandled()) {
                return;
            }
            JCTree.JCCompilationUnit top = (JCTree.JCCompilationUnit)((JavacNode)annotationNode.top()).get();
            boolean handled = JavacTransformer.this.handlers.handleAnnotation(top, annotationNode, annotation);
            if (handled) {
                annotationNode.setHandled();
            }
        }

        @Override
        public void visitAnnotationOnMethod(JCTree.JCMethodDecl method, JavacNode annotationNode, JCTree.JCAnnotation annotation) {
            if (annotationNode.isHandled()) {
                return;
            }
            JCTree.JCCompilationUnit top = (JCTree.JCCompilationUnit)((JavacNode)annotationNode.top()).get();
            boolean handled = JavacTransformer.this.handlers.handleAnnotation(top, annotationNode, annotation);
            if (handled) {
                annotationNode.setHandled();
            }
        }

        @Override
        public void visitAnnotationOnMethodArgument(JCTree.JCVariableDecl argument, JCTree.JCMethodDecl method, JavacNode annotationNode, JCTree.JCAnnotation annotation) {
            if (annotationNode.isHandled()) {
                return;
            }
            JCTree.JCCompilationUnit top = (JCTree.JCCompilationUnit)((JavacNode)annotationNode.top()).get();
            boolean handled = JavacTransformer.this.handlers.handleAnnotation(top, annotationNode, annotation);
            if (handled) {
                annotationNode.setHandled();
            }
        }

        @Override
        public void visitAnnotationOnLocal(JCTree.JCVariableDecl local, JavacNode annotationNode, JCTree.JCAnnotation annotation) {
            if (annotationNode.isHandled()) {
                return;
            }
            JCTree.JCCompilationUnit top = (JCTree.JCCompilationUnit)((JavacNode)annotationNode.top()).get();
            boolean handled = JavacTransformer.this.handlers.handleAnnotation(top, annotationNode, annotation);
            if (handled) {
                annotationNode.setHandled();
            }
        }
    }
}

