/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.apt;

import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import java.util.IdentityHashMap;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import lombok.javac.JavacTransformer;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class Processor
extends AbstractProcessor {
    private ProcessingEnvironment rawProcessingEnv;
    private JavacProcessingEnvironment processingEnv;
    private JavacTransformer transformer;
    private Trees trees;
    private String errorToShow;

    @Override
    public void init(ProcessingEnvironment procEnv) {
        super.init(procEnv);
        this.rawProcessingEnv = procEnv;
        String className = procEnv.getClass().getName();
        if (className.startsWith("org.eclipse.jdt.")) {
            this.errorToShow = "You should not install lombok.jar as an annotation processor in eclipse. Instead, run lombok.jar as a java application and follow the instructions.";
            procEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, this.errorToShow);
            this.processingEnv = null;
        } else if (!procEnv.getClass().getName().equals("com.sun.tools.javac.processing.JavacProcessingEnvironment")) {
            procEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "You aren't using a compiler based around javac v1.6, so lombok will not work properly.\nYour processor class is: " + className);
            this.processingEnv = null;
            this.errorToShow = null;
        } else {
            this.processingEnv = (JavacProcessingEnvironment)procEnv;
            this.transformer = new JavacTransformer(procEnv.getMessager());
            this.trees = Trees.instance(procEnv);
            this.errorToShow = null;
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.processingEnv == null) {
            Set<? extends Element> rootElements;
            if (this.errorToShow != null && !(rootElements = roundEnv.getRootElements()).isEmpty()) {
                this.rawProcessingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, this.errorToShow, rootElements.iterator().next());
                this.errorToShow = null;
            }
            return false;
        }
        IdentityHashMap units = new IdentityHashMap();
        for (Element element : roundEnv.getRootElements()) {
            JCTree.JCCompilationUnit unit = this.toUnit(element);
            if (unit == null) continue;
            units.put(unit, null);
        }
        this.transformer.transform(this.processingEnv.getContext(), units.keySet());
        return false;
    }

    private JCTree.JCCompilationUnit toUnit(Element element) {
        TreePath path;
        TreePath treePath = path = this.trees == null ? null : this.trees.getPath(element);
        if (path == null) {
            return null;
        }
        return (JCTree.JCCompilationUnit)path.getCompilationUnit();
    }
}

