/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Data;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.handlers.TransformationsUtil;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.HandleEqualsAndHashCode;
import lombok.javac.handlers.HandleGetter;
import lombok.javac.handlers.HandleSetter;
import lombok.javac.handlers.HandleToString;
import lombok.javac.handlers.JavacHandlerUtil;

public class HandleData
implements JavacAnnotationHandler<Data> {
    @Override
    public boolean handle(AnnotationValues<Data> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        boolean notAClass;
        JavacHandlerUtil.markAnnotationAsProcessed(annotationNode, Data.class);
        JavacNode typeNode = (JavacNode)annotationNode.up();
        JCTree.JCClassDecl typeDecl = null;
        if (typeNode.get() instanceof JCTree.JCClassDecl) {
            typeDecl = (JCTree.JCClassDecl)typeNode.get();
        }
        long flags = typeDecl == null ? 0L : typeDecl.mods.flags;
        boolean bl = notAClass = (flags & 0x6200L) != 0L;
        if (typeDecl == null || notAClass) {
            annotationNode.addError("@Data is only supported on a class.");
            return false;
        }
        List<JavacNode> nodesForConstructor = List.nil();
        LinkedHashMap<JavacNode, Boolean> gettersAndSetters = new LinkedHashMap<JavacNode, Boolean>();
        for (JavacNode child : typeNode.down()) {
            boolean isNonNull;
            long fieldFlags;
            if (child.getKind() != AST.Kind.FIELD) continue;
            JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)child.get();
            if (fieldDecl.name.toString().startsWith("$") || ((fieldFlags = fieldDecl.mods.flags) & 8L) != 0L) continue;
            boolean isFinal = (fieldFlags & 0x10L) != 0L;
            boolean bl2 = isNonNull = !JavacHandlerUtil.findAnnotations(child, TransformationsUtil.NON_NULL_PATTERN).isEmpty();
            if ((isFinal || isNonNull) && fieldDecl.init == null) {
                nodesForConstructor = nodesForConstructor.append(child);
            }
            gettersAndSetters.put(child, !isFinal);
        }
        String staticConstructorName = annotation.getInstance().staticConstructor();
        if (JavacHandlerUtil.constructorExists(typeNode) == JavacHandlerUtil.MemberExistsResult.NOT_EXISTS) {
            JCTree.JCMethodDecl constructor = this.createConstructor(staticConstructorName.equals(""), typeNode, nodesForConstructor);
            JavacHandlerUtil.injectMethod(typeNode, constructor);
        }
        if (!staticConstructorName.isEmpty() && JavacHandlerUtil.methodExists("of", typeNode, false) == JavacHandlerUtil.MemberExistsResult.NOT_EXISTS) {
            JCTree.JCMethodDecl staticConstructor = this.createStaticConstructor(staticConstructorName, typeNode, nodesForConstructor);
            JavacHandlerUtil.injectMethod(typeNode, staticConstructor);
        }
        for (Map.Entry field : gettersAndSetters.entrySet()) {
            new HandleGetter().generateGetterForField((JavacNode)field.getKey(), (JCDiagnostic.DiagnosticPosition)annotationNode.get());
            if (!((Boolean)field.getValue()).booleanValue()) continue;
            new HandleSetter().generateSetterForField((JavacNode)field.getKey(), (JCDiagnostic.DiagnosticPosition)annotationNode.get());
        }
        new HandleEqualsAndHashCode().generateEqualsAndHashCodeForType(typeNode, annotationNode);
        new HandleToString().generateToStringForType(typeNode, annotationNode);
        return true;
    }

    private JCTree.JCMethodDecl createConstructor(boolean isPublic, JavacNode typeNode, List<JavacNode> fields) {
        TreeMaker maker = typeNode.getTreeMaker();
        JCTree.JCClassDecl type = (JCTree.JCClassDecl)typeNode.get();
        List<JCTree.JCStatement> nullChecks = List.nil();
        List<JCTree.JCExpressionStatement> assigns = List.nil();
        List<JCTree.JCVariableDecl> params = List.nil();
        for (JavacNode fieldNode : fields) {
            JCTree.JCStatement nullCheck;
            JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)fieldNode.get();
            List<JCTree.JCAnnotation> nonNulls = JavacHandlerUtil.findAnnotations(fieldNode, TransformationsUtil.NON_NULL_PATTERN);
            List<JCTree.JCAnnotation> nullables = JavacHandlerUtil.findAnnotations(fieldNode, TransformationsUtil.NULLABLE_PATTERN);
            JCTree.JCVariableDecl param = maker.VarDef(maker.Modifiers(16L, nonNulls.appendList(nullables)), field.name, field.vartype, null);
            params = params.append(param);
            JCTree.JCFieldAccess thisX = maker.Select((JCTree.JCExpression)maker.Ident(fieldNode.toName("this")), field.name);
            JCTree.JCAssign assign = maker.Assign(thisX, maker.Ident(field.name));
            assigns = assigns.append(maker.Exec(assign));
            if (nonNulls.isEmpty() || (nullCheck = JavacHandlerUtil.generateNullCheck(maker, fieldNode)) == null) continue;
            nullChecks = nullChecks.append(nullCheck);
        }
        JCTree.JCModifiers mods = maker.Modifiers(isPublic ? 1L : 2L);
        return maker.MethodDef(mods, typeNode.toName("<init>"), null, type.typarams, params, List.<JCTree.JCExpression>nil(), maker.Block(0L, nullChecks.appendList(assigns)), null);
    }

    private JCTree.JCMethodDecl createStaticConstructor(String name, JavacNode typeNode, List<JavacNode> fields) {
        JCTree.JCExpression constructorType;
        JCTree.JCExpression returnType;
        TreeMaker maker = typeNode.getTreeMaker();
        JCTree.JCClassDecl type = (JCTree.JCClassDecl)typeNode.get();
        JCTree.JCModifiers mods = maker.Modifiers(9L);
        List<JCTree.JCTypeParameter> typeParams = List.nil();
        List<JCTree.JCVariableDecl> params = List.nil();
        List<JCTree.JCExpression> typeArgs1 = List.nil();
        List<JCTree.JCExpression> typeArgs2 = List.nil();
        List<JCTree.JCExpression> args = List.nil();
        if (!type.typarams.isEmpty()) {
            for (JCTree.JCTypeParameter param : type.typarams) {
                typeArgs1 = typeArgs1.append(maker.Ident(param.name));
                typeArgs2 = typeArgs2.append(maker.Ident(param.name));
                typeParams = typeParams.append(maker.TypeParameter(param.name, param.bounds));
            }
            returnType = maker.TypeApply(maker.Ident(type.name), typeArgs1);
            constructorType = maker.TypeApply(maker.Ident(type.name), typeArgs2);
        } else {
            returnType = maker.Ident(type.name);
            constructorType = maker.Ident(type.name);
        }
        for (JavacNode fieldNode : fields) {
            JCTree.JCExpression pType;
            JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)fieldNode.get();
            if (field.vartype instanceof JCTree.JCIdent) {
                pType = maker.Ident(((JCTree.JCIdent)field.vartype).name);
            } else if (field.vartype instanceof JCTree.JCTypeApply) {
                JCTree.JCTypeApply typeApply = (JCTree.JCTypeApply)field.vartype;
                List<JCTree.JCExpression> tArgs = List.nil();
                for (JCTree.JCExpression arg : typeApply.arguments) {
                    tArgs = tArgs.append(arg);
                }
                pType = maker.TypeApply(typeApply.clazz, tArgs);
            } else {
                pType = field.vartype;
            }
            List<JCTree.JCAnnotation> nonNulls = JavacHandlerUtil.findAnnotations(fieldNode, TransformationsUtil.NON_NULL_PATTERN);
            List<JCTree.JCAnnotation> nullables = JavacHandlerUtil.findAnnotations(fieldNode, TransformationsUtil.NULLABLE_PATTERN);
            JCTree.JCVariableDecl param = maker.VarDef(maker.Modifiers(16L, nonNulls.appendList(nullables)), field.name, pType, null);
            params = params.append(param);
            args = args.append(maker.Ident(field.name));
        }
        JCTree.JCReturn returnStatement = maker.Return(maker.NewClass(null, List.<JCTree.JCExpression>nil(), constructorType, args, null));
        JCTree.JCBlock body = maker.Block(0L, List.of(returnStatement));
        return maker.MethodDef(mods, typeNode.toName(name), returnType, typeParams, params, List.<JCTree.JCExpression>nil(), body, null);
    }
}

