/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Lombok;
import lombok.core.AnnotationValues;
import lombok.core.PrintAST;
import lombok.core.SpiLoadUtil;
import lombok.core.TypeLibrary;
import lombok.core.TypeResolver;
import lombok.eclipse.Eclipse;
import lombok.eclipse.EclipseAST;
import lombok.eclipse.EclipseASTVisitor;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;

public class HandlerLibrary {
    private TypeLibrary typeLibrary = new TypeLibrary();
    private Map<String, AnnotationHandlerContainer<?>> annotationHandlers = new HashMap();
    private Collection<EclipseASTVisitor> visitorHandlers = new ArrayList<EclipseASTVisitor>();
    private boolean skipPrintAST;

    public static HandlerLibrary load() {
        HandlerLibrary lib = new HandlerLibrary();
        HandlerLibrary.loadAnnotationHandlers(lib);
        HandlerLibrary.loadVisitorHandlers(lib);
        return lib;
    }

    private static void loadAnnotationHandlers(HandlerLibrary lib) {
        try {
            for (EclipseAnnotationHandler handler : SpiLoadUtil.findServices(EclipseAnnotationHandler.class)) {
                try {
                    Class<? extends java.lang.annotation.Annotation> annotationClass = SpiLoadUtil.findAnnotationClass(handler.getClass(), EclipseAnnotationHandler.class);
                    AnnotationHandlerContainer<? extends java.lang.annotation.Annotation> container = new AnnotationHandlerContainer<java.lang.annotation.Annotation>(handler, annotationClass);
                    if (lib.annotationHandlers.put(((AnnotationHandlerContainer)container).annotationClass.getName(), container) != null) {
                        Eclipse.error(null, "Duplicate handlers for annotation type: " + ((AnnotationHandlerContainer)container).annotationClass.getName());
                    }
                    lib.typeLibrary.addType(((AnnotationHandlerContainer)container).annotationClass.getName());
                }
                catch (Throwable t) {
                    Eclipse.error(null, "Can't load Lombok annotation handler for Eclipse: ", t);
                }
            }
        }
        catch (IOException e) {
            Lombok.sneakyThrow(e);
        }
    }

    private static void loadVisitorHandlers(HandlerLibrary lib) {
        try {
            for (EclipseASTVisitor visitor : SpiLoadUtil.findServices(EclipseASTVisitor.class)) {
                lib.visitorHandlers.add(visitor);
            }
        }
        catch (Throwable t) {
            throw Lombok.sneakyThrow(t);
        }
    }

    public boolean handle(CompilationUnitDeclaration ast, EclipseNode annotationNode, Annotation annotation) {
        String pkgName = annotationNode.getPackageDeclaration();
        Collection<String> imports = annotationNode.getImportStatements();
        TypeResolver resolver = new TypeResolver(this.typeLibrary, pkgName, imports);
        TypeReference rawType = annotation.type;
        if (rawType == null) {
            return false;
        }
        boolean handled = false;
        for (String fqn : resolver.findTypeMatches(annotationNode, Eclipse.toQualifiedName(annotation.type.getTypeName()))) {
            AnnotationHandlerContainer<?> container;
            boolean isPrintAST = fqn.equals(PrintAST.class.getName());
            if (isPrintAST == this.skipPrintAST || (container = this.annotationHandlers.get(fqn)) == null) continue;
            try {
                handled |= container.handle(annotation, annotationNode);
            }
            catch (AnnotationValues.AnnotationValueDecodeFail fail) {
                fail.owner.setError(fail.getMessage(), fail.idx);
            }
            catch (Throwable t) {
                Eclipse.error(ast, String.format("Lombok annotation handler %s failed", ((AnnotationHandlerContainer)container).handler.getClass()), t);
            }
        }
        return handled;
    }

    public void callASTVisitors(EclipseAST ast) {
        for (EclipseASTVisitor visitor : this.visitorHandlers) {
            try {
                ast.traverse(visitor);
            }
            catch (Throwable t) {
                Eclipse.error((CompilationUnitDeclaration)((EclipseNode)ast.top()).get(), String.format("Lombok visitor handler %s failed", visitor.getClass()), t);
            }
        }
    }

    public void skipPrintAST() {
        this.skipPrintAST = true;
    }

    public void skipAllButPrintAST() {
        this.skipPrintAST = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotationHandlerContainer<T extends java.lang.annotation.Annotation> {
        private EclipseAnnotationHandler<T> handler;
        private Class<T> annotationClass;

        AnnotationHandlerContainer(EclipseAnnotationHandler<T> handler, Class<T> annotationClass) {
            this.handler = handler;
            this.annotationClass = annotationClass;
        }

        public boolean handle(Annotation annotation, EclipseNode annotationNode) {
            AnnotationValues<T> annValues = Eclipse.createAnnotation(this.annotationClass, annotationNode);
            return this.handler.handle(annValues, annotation, annotationNode);
        }
    }
}

