/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.handlers.TransformationsUtil;
import lombok.eclipse.Eclipse;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseHandlerUtil;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandleGetter
implements EclipseAnnotationHandler<Getter> {
    public void generateGetterForField(EclipseNode fieldNode, ASTNode pos) {
        for (EclipseNode child : fieldNode.down()) {
            if (child.getKind() != AST.Kind.ANNOTATION || !Eclipse.annotationTypeMatches(Getter.class, child)) continue;
            return;
        }
        this.createGetterForField(AccessLevel.PUBLIC, fieldNode, fieldNode, pos, false);
    }

    @Override
    public boolean handle(AnnotationValues<Getter> annotation, Annotation ast, EclipseNode annotationNode) {
        EclipseNode fieldNode = (EclipseNode)annotationNode.up();
        AccessLevel level = annotation.getInstance().value();
        if (level == AccessLevel.NONE) {
            return true;
        }
        return this.createGetterForField(level, fieldNode, annotationNode, (ASTNode)annotationNode.get(), true);
    }

    private boolean createGetterForField(AccessLevel level, EclipseNode fieldNode, EclipseNode errorNode, ASTNode source, boolean whineIfExists) {
        if (fieldNode.getKind() != AST.Kind.FIELD) {
            errorNode.addError("@Getter is only supported on a field.");
            return true;
        }
        FieldDeclaration field = (FieldDeclaration)fieldNode.get();
        TypeReference fieldType = Eclipse.copyType(field.type, source);
        String fieldName = new String(field.name);
        boolean isBoolean = EclipseHandlerUtil.nameEquals(fieldType.getTypeName(), "boolean") && fieldType.dimensions() == 0;
        String getterName = TransformationsUtil.toGetterName(fieldName, isBoolean);
        int modifier = EclipseHandlerUtil.toEclipseModifier(level) | field.modifiers & 8;
        for (String altName : TransformationsUtil.toAllGetterNames(fieldName, isBoolean)) {
            switch (EclipseHandlerUtil.methodExists(altName, fieldNode, false)) {
                case EXISTS_BY_LOMBOK: {
                    return true;
                }
                case EXISTS_BY_USER: {
                    if (whineIfExists) {
                        String altNameExpl = "";
                        if (!altName.equals(getterName)) {
                            altNameExpl = String.format(" (%s)", altName);
                        }
                        errorNode.addWarning(String.format("Not generating %s(): A method with that name already exists%s", getterName, altNameExpl));
                    }
                    return true;
                }
            }
        }
        MethodDeclaration method = this.generateGetter((TypeDeclaration)((EclipseNode)fieldNode.up()).get(), field, getterName, modifier, source);
        Annotation[] copiedAnnotations = Eclipse.copyAnnotations(EclipseHandlerUtil.findAnnotations(field, TransformationsUtil.NON_NULL_PATTERN), EclipseHandlerUtil.findAnnotations(field, TransformationsUtil.NULLABLE_PATTERN), source);
        if (copiedAnnotations.length != 0) {
            method.annotations = copiedAnnotations;
        }
        EclipseHandlerUtil.injectMethod((EclipseNode)fieldNode.up(), (AbstractMethodDeclaration)method);
        return true;
    }

    private MethodDeclaration generateGetter(TypeDeclaration parent, FieldDeclaration field, String name, int modifier, ASTNode source) {
        MethodDeclaration method = new MethodDeclaration(parent.compilationResult);
        Eclipse.setGeneratedBy((ASTNode)method, source);
        method.modifiers = modifier;
        method.returnType = Eclipse.copyType(field.type, source);
        method.annotations = null;
        method.arguments = null;
        method.selector = name.toCharArray();
        method.binding = null;
        method.thrownExceptions = null;
        method.typeParameters = null;
        method.bits |= 0x800000;
        SingleNameReference fieldExpression = new SingleNameReference(field.name, (long)field.declarationSourceStart << 32 | (long)field.declarationSourceEnd);
        Eclipse.setGeneratedBy((ASTNode)fieldExpression, source);
        ReturnStatement returnStatement = new ReturnStatement((Expression)fieldExpression, field.sourceStart, field.sourceEnd);
        Eclipse.setGeneratedBy((ASTNode)returnStatement, source);
        method.declarationSourceStart = method.sourceStart = source.sourceStart;
        method.bodyStart = method.sourceStart;
        method.declarationSourceEnd = method.sourceEnd = source.sourceEnd;
        method.bodyEnd = method.sourceEnd;
        method.statements = new Statement[]{returnStatement};
        return method;
    }
}

