/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import lombok.Cleanup;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.JavacHandlerUtil;

public class HandleCleanup
implements JavacAnnotationHandler<Cleanup> {
    @Override
    public boolean handle(AnnotationValues<Cleanup> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        List<JCTree.JCStatement> statements;
        JavacHandlerUtil.markAnnotationAsProcessed(annotationNode, Cleanup.class);
        String cleanupName = annotation.getInstance().value();
        if (cleanupName.length() == 0) {
            annotationNode.addError("cleanupName cannot be the empty string.");
            return true;
        }
        if (((JavacNode)annotationNode.up()).getKind() != AST.Kind.LOCAL) {
            annotationNode.addError("@Cleanup is legal only on local variable declarations.");
            return true;
        }
        JCTree.JCVariableDecl decl = (JCTree.JCVariableDecl)((JavacNode)annotationNode.up()).get();
        if (decl.init == null) {
            annotationNode.addError("@Cleanup variable declarations need to be initialized.");
            return true;
        }
        JavacNode ancestor = (JavacNode)((JavacNode)annotationNode.up()).directUp();
        JCTree blockNode = (JCTree)ancestor.get();
        if (blockNode instanceof JCTree.JCBlock) {
            statements = ((JCTree.JCBlock)blockNode).stats;
        } else if (blockNode instanceof JCTree.JCCase) {
            statements = ((JCTree.JCCase)blockNode).stats;
        } else if (blockNode instanceof JCTree.JCMethodDecl) {
            statements = ((JCTree.JCMethodDecl)blockNode).body.stats;
        } else {
            annotationNode.addError("@Cleanup is legal only on a local variable declaration inside a block.");
            return true;
        }
        boolean seenDeclaration = false;
        List<JCTree.JCStatement> tryBlock = List.nil();
        List<Object> newStatements = List.nil();
        for (JCTree.JCStatement statement : statements) {
            if (!seenDeclaration) {
                if (statement == decl) {
                    seenDeclaration = true;
                }
                newStatements = newStatements.append(statement);
                continue;
            }
            tryBlock = tryBlock.append(statement);
        }
        if (!seenDeclaration) {
            annotationNode.addError("LOMBOK BUG: Can't find this local variable declaration inside its parent.");
            return true;
        }
        this.doAssignmentCheck(annotationNode, tryBlock, decl.name);
        TreeMaker maker = annotationNode.getTreeMaker();
        JCTree.JCFieldAccess cleanupCall = maker.Select((JCTree.JCExpression)maker.Ident(decl.name), annotationNode.toName(cleanupName));
        List<JCTree.JCStatement> finalizerBlock = List.of(maker.Exec(maker.Apply(List.<JCTree.JCExpression>nil(), cleanupCall, List.<JCTree.JCExpression>nil())));
        JCTree.JCBlock finalizer = maker.Block(0L, finalizerBlock);
        newStatements = newStatements.append(maker.Try(maker.Block(0L, tryBlock), List.<JCTree.JCCatch>nil(), finalizer));
        if (blockNode instanceof JCTree.JCBlock) {
            ((JCTree.JCBlock)blockNode).stats = newStatements;
        } else if (blockNode instanceof JCTree.JCCase) {
            ((JCTree.JCCase)blockNode).stats = newStatements;
        } else if (blockNode instanceof JCTree.JCMethodDecl) {
            ((JCTree.JCMethodDecl)blockNode).body.stats = newStatements;
        } else {
            throw new AssertionError((Object)"Should not get here");
        }
        ancestor.rebuild();
        return true;
    }

    private void doAssignmentCheck(JavacNode node, List<JCTree.JCStatement> statements, Name name) {
        for (JCTree.JCStatement statement : statements) {
            this.doAssignmentCheck0(node, statement, name);
        }
    }

    private void doAssignmentCheck0(JavacNode node, JCTree statement, Name name) {
        JavacNode problemNode;
        if (statement instanceof JCTree.JCAssign) {
            this.doAssignmentCheck0(node, ((JCTree.JCAssign)statement).rhs, name);
        }
        if (statement instanceof JCTree.JCExpressionStatement) {
            this.doAssignmentCheck0(node, ((JCTree.JCExpressionStatement)statement).expr, name);
        }
        if (statement instanceof JCTree.JCVariableDecl) {
            this.doAssignmentCheck0(node, ((JCTree.JCVariableDecl)statement).init, name);
        }
        if (statement instanceof JCTree.JCTypeCast) {
            this.doAssignmentCheck0(node, ((JCTree.JCTypeCast)statement).expr, name);
        }
        if (statement instanceof JCTree.JCIdent && ((JCTree.JCIdent)statement).name.contentEquals(name) && (problemNode = (JavacNode)node.getNodeFor(statement)) != null) {
            problemNode.addWarning("You're assigning an auto-cleanup variable to something else. This is a bad idea.");
        }
    }
}

