/*
 * Decompiled with CFR 0.152.
 */
package lombok.installer.netbeans;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.installer.CorruptedIdeLocationException;
import lombok.installer.IdeFinder;
import lombok.installer.IdeLocation;
import lombok.installer.InstallException;
import lombok.installer.UninstallException;

public class NetbeansLocation
extends IdeLocation {
    private final String name;
    private final File netbeansConfPath;
    private volatile boolean hasLombok;
    private static final String OS_NEWLINE = IdeFinder.getOS().getLineEnding();
    private final String ID_CHARS = "(?:\\\\.|[^\"\\\\])*";
    private final Pattern JAVA_AGENT_LINE_MATCHER = Pattern.compile("^\\s*netbeans_default_options\\s*=\\s*\"\\s*(?:\\\\.|[^\"\\\\])*(?<=[ \"])(-J-javaagent:\\\\\".*lombok.*\\.jar\\\\\")(?=[ \"])(?:\\\\.|[^\"\\\\])*\\s*\"\\s*(?:#.*)?$", 2);
    private final Pattern OPTIONS_LINE_MATCHER = Pattern.compile("^\\s*netbeans_default_options\\s*=\\s*\"\\s*(?:\\\\.|[^\"\\\\])*\\s*(\")\\s*(?:#.*)?$", 2);

    NetbeansLocation(String nameOfLocation, File pathToNetbeansConf) throws CorruptedIdeLocationException {
        this.name = nameOfLocation;
        this.netbeansConfPath = pathToNetbeansConf;
        try {
            this.hasLombok = this.checkForLombok(this.netbeansConfPath);
        }
        catch (IOException e) {
            throw new CorruptedIdeLocationException("I can't read the configuration file of the Netbeans installed at " + this.name + "\n" + "You may need to run this installer with root privileges if you want to modify that Netbeans.", "netbeans", e);
        }
    }

    public int hashCode() {
        return this.netbeansConfPath.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof NetbeansLocation)) {
            return false;
        }
        return ((NetbeansLocation)o).netbeansConfPath.equals(this.netbeansConfPath);
    }

    public String getName() {
        return this.name;
    }

    public boolean hasLombok() {
        return this.hasLombok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForLombok(File iniFile) throws IOException {
        if (!iniFile.exists()) {
            return false;
        }
        FileInputStream fis = new FileInputStream(iniFile);
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            while ((line = br.readLine()) != null) {
                if (!this.JAVA_AGENT_LINE_MATCHER.matcher(line.trim()).matches()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall() throws UninstallException {
        File dir = this.netbeansConfPath.getParentFile();
        File lombokJar = new File(dir, "lombok.jar");
        if (lombokJar.exists() && !lombokJar.delete()) {
            throw new UninstallException("Can't delete " + lombokJar.getAbsolutePath() + NetbeansLocation.generateWriteErrorMessage(), null);
        }
        StringBuilder newContents = new StringBuilder();
        if (this.netbeansConfPath.exists()) {
            try {
                FileInputStream fis = new FileInputStream(this.netbeansConfPath);
                try {
                    String line;
                    BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                    while ((line = br.readLine()) != null) {
                        Matcher m = this.JAVA_AGENT_LINE_MATCHER.matcher(line);
                        if (m.matches()) {
                            newContents.append(line.substring(0, m.start(1)) + line.substring(m.end(1)));
                        } else {
                            newContents.append(line);
                        }
                        newContents.append(OS_NEWLINE);
                    }
                }
                finally {
                    fis.close();
                }
                FileOutputStream fos = new FileOutputStream(this.netbeansConfPath);
                try {
                    fos.write(newContents.toString().getBytes());
                }
                finally {
                    fos.close();
                }
            }
            catch (IOException e) {
                throw new UninstallException("Cannot uninstall lombok from " + this.name + NetbeansLocation.generateWriteErrorMessage(), e);
            }
        }
    }

    private static String generateWriteErrorMessage() {
        String osSpecificError;
        switch (IdeFinder.getOS()) {
            default: {
                osSpecificError = ":\nStart terminal, go to the directory with lombok.jar, and run: sudo java -jar lombok.jar";
                break;
            }
            case WINDOWS: {
                osSpecificError = ":\nStart a new cmd (dos box) with admin privileges, go to the directory with lombok.jar, and run: java -jar lombok.jar";
            }
        }
        return ", probably because this installer does not have the access rights.\nTry re-running the installer with administrative privileges" + osSpecificError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String install() throws InstallException {
        boolean installSucceeded = false;
        StringBuilder newContents = new StringBuilder();
        File lombokJar = new File(this.netbeansConfPath.getParentFile(), "lombok.jar");
        File ourJar = NetbeansLocation.findOurJar();
        byte[] b = new byte[524288];
        boolean readSucceeded = true;
        try {
            FileOutputStream out = new FileOutputStream(lombokJar);
            try {
                readSucceeded = false;
                FileInputStream in = new FileInputStream(ourJar);
                try {
                    int r;
                    while ((r = ((InputStream)in).read(b)) != -1) {
                        if (r > 0) {
                            readSucceeded = true;
                        }
                        out.write(b, 0, r);
                    }
                }
                finally {
                    ((InputStream)in).close();
                }
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            try {
                lombokJar.delete();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            if (!readSucceeded) {
                throw new InstallException("I can't read my own jar file. I think you've found a bug in this installer!\nI suggest you restart it and use the 'what do I do' link, to manually install lombok. Also, tell us about this at:\nhttp://groups.google.com/group/project-lombok - Thanks!", e);
            }
            throw new InstallException("I can't write to your Netbeans directory at " + this.name + NetbeansLocation.generateWriteErrorMessage(), e);
        }
        try {
            FileInputStream fis = new FileInputStream(this.netbeansConfPath);
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                while ((line = br.readLine()) != null) {
                    Matcher m = this.JAVA_AGENT_LINE_MATCHER.matcher(line);
                    if (m.matches()) {
                        newContents.append(line.substring(0, m.start(1)));
                        newContents.append("-J-javaagent:\\\"" + NetbeansLocation.canonical(lombokJar) + "\\\"");
                        newContents.append(line.substring(m.end(1)));
                        newContents.append(OS_NEWLINE);
                        continue;
                    }
                    m = this.OPTIONS_LINE_MATCHER.matcher(line);
                    if (m.matches()) {
                        newContents.append(line.substring(0, m.start(1)));
                        newContents.append(" ").append("-J-javaagent:\\\"" + NetbeansLocation.canonical(lombokJar) + "\\\"\"");
                        newContents.append(line.substring(m.end(1))).append(OS_NEWLINE);
                        continue;
                    }
                    newContents.append(line).append(OS_NEWLINE);
                }
            }
            finally {
                fis.close();
            }
            FileOutputStream fos = new FileOutputStream(this.netbeansConfPath);
            try {
                fos.write(newContents.toString().getBytes());
            }
            finally {
                fos.close();
            }
            installSucceeded = true;
        }
        catch (IOException e) {
            throw new InstallException("Cannot install lombok at " + this.name + NetbeansLocation.generateWriteErrorMessage(), e);
        }
        finally {
            if (!installSucceeded) {
                try {
                    lombokJar.delete();
                }
                catch (Throwable ignore) {}
            }
        }
        if (!installSucceeded) {
            throw new InstallException("I can't find the netbeans.conf file. Is this a real Netbeans installation?", null);
        }
        return "If you start netbeans with custom parameters, you'll need to add:<br><code>-J-javaagent:\\\"" + NetbeansLocation.canonical(lombokJar) + "\\\"</code><br>" + "as parameter as well.";
    }

    public URL getIdeIcon() {
        return NetbeansLocation.class.getResource("netbeans.png");
    }
}

