/*
 * Decompiled with CFR 0.152.
 */
package lombok.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import lombok.Lombok;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpiLoadUtil {
    private SpiLoadUtil() {
    }

    public static <T> List<T> readAllFromIterator(Iterable<T> findServices) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : findServices) {
            list.add(t);
        }
        return list;
    }

    public static <C> Iterable<C> findServices(Class<C> target) throws IOException {
        return SpiLoadUtil.findServices(target, Thread.currentThread().getContextClassLoader());
    }

    public static <C> Iterable<C> findServices(final Class<C> target, final ClassLoader loader) throws IOException {
        Enumeration<URL> resources = loader.getResources("META-INF/services/" + target.getName());
        LinkedHashSet<String> entries = new LinkedHashSet<String>();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            SpiLoadUtil.readServicesFromUrl(entries, url);
        }
        final Iterator names = entries.iterator();
        return new Iterable<C>(){

            @Override
            public Iterator<C> iterator() {
                return new Iterator<C>(){

                    @Override
                    public boolean hasNext() {
                        return names.hasNext();
                    }

                    @Override
                    public C next() {
                        try {
                            return target.cast(Class.forName((String)names.next(), true, loader).newInstance());
                        }
                        catch (Throwable t) {
                            throw Lombok.sneakyThrow(t);
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readServicesFromUrl(Collection<String> list, URL url) throws IOException {
        InputStream in = url.openStream();
        try {
            String line;
            if (in == null) {
                return;
            }
            BufferedReader r = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            while ((line = r.readLine()) != null) {
                int idx = line.indexOf(35);
                if (idx != -1) {
                    line = line.substring(0, idx);
                }
                if ((line = line.trim()).length() == 0) continue;
                list.add(line);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Throwable ignore) {}
        }
    }

    public static Class<? extends Annotation> findAnnotationClass(Class<?> c, Class<?> base) {
        if (c == Object.class || c == null) {
            return null;
        }
        for (Type iface : c.getGenericInterfaces()) {
            ParameterizedType p;
            if (!(iface instanceof ParameterizedType) || !base.equals((p = (ParameterizedType)iface).getRawType())) continue;
            Type target = p.getActualTypeArguments()[0];
            if (target instanceof Class && Annotation.class.isAssignableFrom((Class)target)) {
                return (Class)target;
            }
            throw new ClassCastException("Not an annotation type: " + target);
        }
        Class<? extends Annotation> potential = SpiLoadUtil.findAnnotationClass(c.getSuperclass(), base);
        if (potential != null) {
            return potential;
        }
        for (Class<?> iface : c.getInterfaces()) {
            potential = SpiLoadUtil.findAnnotationClass(iface, base);
            if (potential == null) continue;
            return potential;
        }
        return null;
    }
}

