/*
 * Decompiled with CFR 0.152.
 */
package lombok.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeLibrary {
    private final Map<String, Set<String>> simpleToQualifiedMap = new HashMap<String, Set<String>>();

    public void addType(String fullyQualifiedTypeName) {
        int idx = fullyQualifiedTypeName.lastIndexOf(46);
        if (idx == -1) {
            throw new IllegalArgumentException("Only fully qualified types are allowed (and stuff in the default package is not palatable to us either!)");
        }
        String simpleName = fullyQualifiedTypeName.substring(idx + 1);
        String packageName = fullyQualifiedTypeName.substring(0, idx);
        if (this.simpleToQualifiedMap.put(fullyQualifiedTypeName, Collections.singleton(fullyQualifiedTypeName)) != null) {
            return;
        }
        this.addToMap(simpleName, fullyQualifiedTypeName);
        this.addToMap(packageName + ".*", fullyQualifiedTypeName);
    }

    private TypeLibrary addToMap(String keyName, String fullyQualifiedTypeName) {
        Set<String> existing = this.simpleToQualifiedMap.get(keyName);
        HashSet<String> set = existing == null ? new HashSet<String>() : new HashSet<String>(existing);
        set.add(fullyQualifiedTypeName);
        this.simpleToQualifiedMap.put(keyName, Collections.unmodifiableSet(set));
        return this;
    }

    public Collection<String> findCompatible(String typeReference) {
        Set<String> result = this.simpleToQualifiedMap.get(typeReference);
        return result == null ? Collections.emptySet() : result;
    }
}

