/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import lombok.AccessLevel;
import lombok.Setter;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.handlers.TransformationsUtil;
import lombok.eclipse.Eclipse;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseHandlerUtil;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandleSetter
implements EclipseAnnotationHandler<Setter> {
    public void generateSetterForField(EclipseNode fieldNode, ASTNode pos) {
        for (EclipseNode child : fieldNode.down()) {
            if (child.getKind() != AST.Kind.ANNOTATION || !Eclipse.annotationTypeMatches(Setter.class, child)) continue;
            return;
        }
        this.createSetterForField(AccessLevel.PUBLIC, fieldNode, fieldNode, pos, false);
    }

    @Override
    public boolean handle(AnnotationValues<Setter> annotation, Annotation ast, EclipseNode annotationNode) {
        EclipseNode fieldNode = (EclipseNode)annotationNode.up();
        if (fieldNode.getKind() != AST.Kind.FIELD) {
            return false;
        }
        AccessLevel level = annotation.getInstance().value();
        if (level == AccessLevel.NONE) {
            return true;
        }
        return this.createSetterForField(level, fieldNode, annotationNode, (ASTNode)annotationNode.get(), true);
    }

    private boolean createSetterForField(AccessLevel level, EclipseNode fieldNode, EclipseNode errorNode, ASTNode pos, boolean whineIfExists) {
        if (fieldNode.getKind() != AST.Kind.FIELD) {
            errorNode.addError("@Setter is only supported on a field.");
            return true;
        }
        FieldDeclaration field = (FieldDeclaration)fieldNode.get();
        String setterName = TransformationsUtil.toSetterName(new String(field.name));
        int modifier = EclipseHandlerUtil.toEclipseModifier(level) | field.modifiers & 8;
        switch (EclipseHandlerUtil.methodExists(setterName, fieldNode, false)) {
            case EXISTS_BY_LOMBOK: {
                return true;
            }
            case EXISTS_BY_USER: {
                if (whineIfExists) {
                    errorNode.addWarning(String.format("Not generating %s(%s %s): A method with that name already exists", setterName, field.type, new String(field.name)));
                }
                return true;
            }
        }
        MethodDeclaration method = this.generateSetter((TypeDeclaration)((EclipseNode)fieldNode.up()).get(), field, setterName, modifier, pos);
        EclipseHandlerUtil.injectMethod((EclipseNode)fieldNode.up(), (AbstractMethodDeclaration)method);
        return true;
    }

    private MethodDeclaration generateSetter(TypeDeclaration parent, FieldDeclaration field, String name, int modifier, ASTNode source) {
        Statement nullCheck;
        int pS = source.sourceStart;
        int pE = source.sourceEnd;
        long p = (long)pS << 32 | (long)pE;
        MethodDeclaration method = new MethodDeclaration(parent.compilationResult);
        Eclipse.setGeneratedBy((ASTNode)method, source);
        method.modifiers = modifier;
        method.returnType = TypeReference.baseTypeReference((int)6, (int)0);
        method.returnType.sourceStart = pS;
        method.returnType.sourceEnd = pE;
        Eclipse.setGeneratedBy((ASTNode)method.returnType, source);
        method.annotations = null;
        Argument param = new Argument(field.name, p, Eclipse.copyType(field.type, source), 16);
        param.sourceStart = pS;
        param.sourceEnd = pE;
        Eclipse.setGeneratedBy((ASTNode)param, source);
        method.arguments = new Argument[]{param};
        method.selector = name.toCharArray();
        method.binding = null;
        method.thrownExceptions = null;
        method.typeParameters = null;
        method.bits |= 0x800000;
        FieldReference thisX = new FieldReference(field.name, p);
        Eclipse.setGeneratedBy((ASTNode)thisX, source);
        thisX.receiver = new ThisReference(source.sourceStart, source.sourceEnd);
        Eclipse.setGeneratedBy((ASTNode)thisX.receiver, source);
        SingleNameReference fieldNameRef = new SingleNameReference(field.name, p);
        Eclipse.setGeneratedBy((ASTNode)fieldNameRef, source);
        Assignment assignment = new Assignment((Expression)thisX, (Expression)fieldNameRef, (int)p);
        assignment.sourceStart = pS;
        assignment.sourceEnd = pE;
        Eclipse.setGeneratedBy((ASTNode)assignment, source);
        method.declarationSourceStart = method.sourceStart = source.sourceStart;
        method.bodyStart = method.sourceStart;
        method.declarationSourceEnd = method.sourceEnd = source.sourceEnd;
        method.bodyEnd = method.sourceEnd;
        Annotation[] nonNulls = EclipseHandlerUtil.findAnnotations(field, TransformationsUtil.NON_NULL_PATTERN);
        Annotation[] nullables = EclipseHandlerUtil.findAnnotations(field, TransformationsUtil.NULLABLE_PATTERN);
        method.statements = nonNulls.length == 0 ? new Statement[]{assignment} : ((nullCheck = EclipseHandlerUtil.generateNullCheck((AbstractVariableDeclaration)field, source)) != null ? new Statement[]{nullCheck, assignment} : new Statement[]{assignment});
        Annotation[] copiedAnnotations = Eclipse.copyAnnotations(nonNulls, nullables, source);
        if (copiedAnnotations.length != 0) {
            param.annotations = copiedAnnotations;
        }
        return method;
    }
}

