/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import lombok.EqualsAndHashCode;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.javac.Javac;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.JavacHandlerUtil;

public class HandleEqualsAndHashCode
implements JavacAnnotationHandler<EqualsAndHashCode> {
    private void checkForBogusFieldNames(JavacNode type, AnnotationValues<EqualsAndHashCode> annotation) {
        if (annotation.isExplicit("exclude")) {
            for (int i : JavacHandlerUtil.createListOfNonExistentFields(List.from(annotation.getInstance().exclude()), type, true, true)) {
                annotation.setWarning("exclude", "This field does not exist, or would have been excluded anyway.", i);
            }
        }
        if (annotation.isExplicit("of")) {
            for (int i : JavacHandlerUtil.createListOfNonExistentFields(List.from(annotation.getInstance().of()), type, false, false)) {
                annotation.setWarning("of", "This field does not exist.", i);
            }
        }
    }

    @Override
    public boolean handle(AnnotationValues<EqualsAndHashCode> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        JavacHandlerUtil.markAnnotationAsProcessed(annotationNode, EqualsAndHashCode.class);
        EqualsAndHashCode ann = annotation.getInstance();
        List<String> excludes = List.from(ann.exclude());
        List<String> includes = List.from(ann.of());
        JavacNode typeNode = (JavacNode)annotationNode.up();
        this.checkForBogusFieldNames(typeNode, annotation);
        Boolean callSuper = ann.callSuper();
        if (!annotation.isExplicit("callSuper")) {
            callSuper = null;
        }
        if (!annotation.isExplicit("exclude")) {
            excludes = null;
        }
        if (!annotation.isExplicit("of")) {
            includes = null;
        }
        if (excludes != null && includes != null) {
            excludes = null;
            annotation.setWarning("exclude", "exclude and of are mutually exclusive; the 'exclude' parameter will be ignored.");
        }
        return this.generateMethods(typeNode, annotationNode, excludes, includes, callSuper, true);
    }

    public void generateEqualsAndHashCodeForType(JavacNode typeNode, JavacNode errorNode) {
        for (JavacNode child : typeNode.down()) {
            if (child.getKind() != AST.Kind.ANNOTATION || !Javac.annotationTypeMatches(EqualsAndHashCode.class, child)) continue;
            return;
        }
        this.generateMethods(typeNode, errorNode, null, null, null, false);
    }

    private boolean generateMethods(JavacNode typeNode, JavacNode errorNode, List<String> excludes, List<String> includes, Boolean callSuper, boolean whineIfExists) {
        JCTree.JCMethodDecl method;
        JCTree.JCExpression extending;
        boolean implicitCallSuper;
        boolean notAClass = true;
        if (typeNode.get() instanceof JCTree.JCClassDecl) {
            long flags = ((JCTree.JCClassDecl)typeNode.get()).mods.flags;
            boolean bl = notAClass = (flags & 0x6200L) != 0L;
        }
        if (notAClass) {
            errorNode.addError("@EqualsAndHashCode is only supported on a class.");
            return false;
        }
        boolean isDirectDescendantOfObject = true;
        boolean bl = implicitCallSuper = callSuper == null;
        if (callSuper == null) {
            try {
                callSuper = (boolean)((Boolean)EqualsAndHashCode.class.getMethod("callSuper", new Class[0]).getDefaultValue());
            }
            catch (Exception ignore) {
                throw new InternalError("Lombok bug - this cannot happen - can't find callSuper field in EqualsAndHashCode annotation.");
            }
        }
        if ((extending = ((JCTree.JCClassDecl)typeNode.get()).extending) != null) {
            String p = extending.toString();
            boolean bl2 = isDirectDescendantOfObject = p.equals("Object") || p.equals("java.lang.Object");
        }
        if (isDirectDescendantOfObject && callSuper.booleanValue()) {
            errorNode.addError("Generating equals/hashCode with a supercall to java.lang.Object is pointless.");
            return true;
        }
        if (!isDirectDescendantOfObject && !callSuper.booleanValue() && implicitCallSuper) {
            errorNode.addWarning("Generating equals/hashCode implementation but without a call to superclass, even though this class does not extend java.lang.Object. If this is intentional, add '@EqualsAndHashCode(callSuper=false)' to your type.");
        }
        List<JavacNode> nodesForEquality = List.nil();
        if (includes != null) {
            for (JavacNode child : typeNode.down()) {
                if (child.getKind() != AST.Kind.FIELD) continue;
                JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)child.get();
                if (!includes.contains(fieldDecl.name.toString())) continue;
                nodesForEquality = nodesForEquality.append(child);
            }
        } else {
            for (JavacNode child : typeNode.down()) {
                if (child.getKind() != AST.Kind.FIELD) continue;
                JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)child.get();
                if ((fieldDecl.mods.flags & 8L) != 0L || (fieldDecl.mods.flags & 0x80L) != 0L || excludes != null && excludes.contains(fieldDecl.name.toString()) || fieldDecl.name.toString().startsWith("$")) continue;
                nodesForEquality = nodesForEquality.append(child);
            }
        }
        switch (JavacHandlerUtil.methodExists("equals", typeNode)) {
            case NOT_EXISTS: {
                method = this.createEquals(typeNode, nodesForEquality, callSuper);
                JavacHandlerUtil.injectMethod(typeNode, method);
                break;
            }
            case EXISTS_BY_LOMBOK: {
                break;
            }
            default: {
                if (!whineIfExists) break;
                errorNode.addWarning("Not generating equals(Object other): A method with that name already exists");
            }
        }
        switch (JavacHandlerUtil.methodExists("hashCode", typeNode)) {
            case NOT_EXISTS: {
                method = this.createHashCode(typeNode, nodesForEquality, callSuper);
                JavacHandlerUtil.injectMethod(typeNode, method);
                break;
            }
            case EXISTS_BY_LOMBOK: {
                break;
            }
            default: {
                if (!whineIfExists) break;
                errorNode.addWarning("Not generating hashCode(): A method with that name already exists");
            }
        }
        return true;
    }

    private JCTree.JCMethodDecl createHashCode(JavacNode typeNode, List<JavacNode> fields, boolean callSuper) {
        TreeMaker maker = typeNode.getTreeMaker();
        JCTree.JCAnnotation overrideAnnotation = maker.Annotation(JavacHandlerUtil.chainDots(maker, typeNode, "java", "lang", "Override"), List.<JCTree.JCExpression>nil());
        JCTree.JCModifiers mods = maker.Modifiers(1L, List.of(overrideAnnotation));
        JCTree.JCPrimitiveTypeTree returnType = maker.TypeIdent(4);
        List<Object> statements = List.nil();
        Name primeName = typeNode.toName("PRIME");
        Name resultName = typeNode.toName("result");
        if (!fields.isEmpty() || callSuper) {
            statements = statements.append(maker.VarDef(maker.Modifiers(16L), primeName, maker.TypeIdent(4), maker.Literal(31)));
        }
        statements = statements.append(maker.VarDef(maker.Modifiers(0L), resultName, maker.TypeIdent(4), maker.Literal(1)));
        List<Object> intoResult = List.nil();
        if (callSuper) {
            JCTree.JCMethodInvocation callToSuper = maker.Apply(List.<JCTree.JCExpression>nil(), maker.Select((JCTree.JCExpression)maker.Ident(typeNode.toName("super")), typeNode.toName("hashCode")), List.<JCTree.JCExpression>nil());
            intoResult = intoResult.append(callToSuper);
        }
        int tempCounter = 0;
        for (JavacNode javacNode : fields) {
            JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)javacNode.get();
            JCTree.JCExpression fType = field.vartype;
            JCTree.JCFieldAccess thisDotField = maker.Select((JCTree.JCExpression)maker.Ident(typeNode.toName("this")), field.name);
            JCTree.JCFieldAccess thisDotFieldClone = maker.Select((JCTree.JCExpression)maker.Ident(typeNode.toName("this")), field.name);
            if (fType instanceof JCTree.JCPrimitiveTypeTree) {
                switch (((JCTree.JCPrimitiveTypeTree)fType).getPrimitiveTypeKind()) {
                    case BOOLEAN: {
                        intoResult = intoResult.append(maker.Conditional(thisDotField, maker.Literal(1231), maker.Literal(1237)));
                        break;
                    }
                    case LONG: {
                        intoResult = intoResult.append(this.longToIntForHashCode(maker, thisDotField, thisDotFieldClone));
                        break;
                    }
                    case FLOAT: {
                        intoResult = intoResult.append(maker.Apply(List.<JCTree.JCExpression>nil(), JavacHandlerUtil.chainDots(maker, typeNode, "java", "lang", "Float", "floatToIntBits"), List.of(thisDotField)));
                        break;
                    }
                    case DOUBLE: {
                        Name tempVar = typeNode.toName("temp" + ++tempCounter);
                        JCTree.JCMethodInvocation init = maker.Apply(List.<JCTree.JCExpression>nil(), JavacHandlerUtil.chainDots(maker, typeNode, "java", "lang", "Double", "doubleToLongBits"), List.of(thisDotField));
                        statements = statements.append(maker.VarDef(maker.Modifiers(16L), tempVar, maker.TypeIdent(5), init));
                        intoResult = intoResult.append(this.longToIntForHashCode(maker, maker.Ident(tempVar), maker.Ident(tempVar)));
                        break;
                    }
                    default: {
                        intoResult = intoResult.append(thisDotField);
                        break;
                    }
                }
                continue;
            }
            if (fType instanceof JCTree.JCArrayTypeTree) {
                boolean multiDim = ((JCTree.JCArrayTypeTree)fType).elemtype instanceof JCTree.JCArrayTypeTree;
                boolean primitiveArray = ((JCTree.JCArrayTypeTree)fType).elemtype instanceof JCTree.JCPrimitiveTypeTree;
                boolean useDeepHC = multiDim || !primitiveArray;
                JCTree.JCExpression hcMethod = JavacHandlerUtil.chainDots(maker, typeNode, "java", "util", "Arrays", useDeepHC ? "deepHashCode" : "hashCode");
                intoResult = intoResult.append(maker.Apply(List.<JCTree.JCExpression>nil(), hcMethod, List.of(thisDotField)));
                continue;
            }
            JCTree.JCMethodInvocation hcCall = maker.Apply(List.<JCTree.JCExpression>nil(), maker.Select((JCTree.JCExpression)thisDotField, typeNode.toName("hashCode")), List.<JCTree.JCExpression>nil());
            JCTree.JCBinary thisEqualsNull = maker.Binary(60, thisDotField, maker.Literal(17, null));
            intoResult = intoResult.append(maker.Conditional(thisEqualsNull, maker.Literal(0), hcCall));
        }
        for (JCTree.JCExpression jCExpression : intoResult) {
            JCTree.JCBinary mult = maker.Binary(71, maker.Ident(resultName), maker.Ident(primeName));
            JCTree.JCBinary add = maker.Binary(69, mult, jCExpression);
            statements = statements.append(maker.Exec(maker.Assign(maker.Ident(resultName), add)));
        }
        statements = statements.append(maker.Return(maker.Ident(resultName)));
        JCTree.JCBlock body = maker.Block(0L, statements);
        return maker.MethodDef(mods, typeNode.toName("hashCode"), returnType, List.<JCTree.JCTypeParameter>nil(), List.<JCTree.JCVariableDecl>nil(), List.<JCTree.JCExpression>nil(), body, null);
    }

    private JCTree.JCExpression longToIntForHashCode(TreeMaker maker, JCTree.JCExpression ref1, JCTree.JCExpression ref2) {
        JCTree.JCBinary shift = maker.Binary(68, ref1, maker.Literal(32));
        JCTree.JCBinary xorBits = maker.Binary(58, shift, ref2);
        return maker.TypeCast(maker.TypeIdent(4), (JCTree.JCExpression)xorBits);
    }

    private JCTree.JCMethodDecl createEquals(JavacNode typeNode, List<JavacNode> fields, boolean callSuper) {
        JCTree.JCExpression selfType2;
        JCTree.JCExpression selfType1;
        TreeMaker maker = typeNode.getTreeMaker();
        JCTree.JCClassDecl type = (JCTree.JCClassDecl)typeNode.get();
        Name oName = typeNode.toName("o");
        Name otherName = typeNode.toName("other");
        Name thisName = typeNode.toName("this");
        JCTree.JCAnnotation overrideAnnotation = maker.Annotation(JavacHandlerUtil.chainDots(maker, typeNode, "java", "lang", "Override"), List.<JCTree.JCExpression>nil());
        JCTree.JCModifiers mods = maker.Modifiers(1L, List.of(overrideAnnotation));
        JCTree.JCExpression objectType = JavacHandlerUtil.chainDots(maker, typeNode, "java", "lang", "Object");
        JCTree.JCPrimitiveTypeTree returnType = maker.TypeIdent(8);
        List<Object> statements = List.nil();
        List<JCTree.JCVariableDecl> params = List.of(maker.VarDef(maker.Modifiers(16L), oName, objectType, null));
        statements = statements.append(maker.If(maker.Binary(60, maker.Ident(oName), maker.Ident(thisName)), this.returnBool(maker, true), null));
        statements = statements.append(maker.If(maker.Binary(60, maker.Ident(oName), maker.Literal(17, null)), this.returnBool(maker, false), null));
        Name getClass = typeNode.toName("getClass");
        List<JCTree.JCExpression> exprNil = List.nil();
        JCTree.JCMethodInvocation oGetClass = maker.Apply(exprNil, maker.Select((JCTree.JCExpression)maker.Ident(oName), getClass), exprNil);
        JCTree.JCMethodInvocation thisGetClass = maker.Apply(exprNil, maker.Select((JCTree.JCExpression)maker.Ident(thisName), getClass), exprNil);
        statements = statements.append(maker.If(maker.Binary(61, oGetClass, thisGetClass), this.returnBool(maker, false), null));
        if (callSuper) {
            JCTree.JCMethodInvocation callToSuper = maker.Apply(List.<JCTree.JCExpression>nil(), maker.Select((JCTree.JCExpression)maker.Ident(typeNode.toName("super")), typeNode.toName("equals")), List.of(maker.Ident(oName)));
            JCTree.JCUnary superNotEqual = maker.Unary(48, callToSuper);
            statements = statements.append(maker.If(superNotEqual, this.returnBool(maker, false), null));
        }
        List<JCTree.JCExpression> wildcards1 = List.nil();
        List<JCTree.JCExpression> wildcards2 = List.nil();
        for (int i = 0; i < type.typarams.length(); ++i) {
            wildcards1 = wildcards1.append(maker.Wildcard(maker.TypeBoundKind(BoundKind.UNBOUND), null));
            wildcards2 = wildcards2.append(maker.Wildcard(maker.TypeBoundKind(BoundKind.UNBOUND), null));
        }
        if (type.typarams.isEmpty()) {
            selfType1 = maker.Ident(type.name);
            selfType2 = maker.Ident(type.name);
        } else {
            selfType1 = maker.TypeApply(maker.Ident(type.name), wildcards1);
            selfType2 = maker.TypeApply(maker.Ident(type.name), wildcards2);
        }
        statements = statements.append(maker.VarDef(maker.Modifiers(16L), otherName, selfType1, maker.TypeCast(selfType2, (JCTree.JCExpression)maker.Ident(oName))));
        block5: for (JavacNode fieldNode : fields) {
            JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)fieldNode.get();
            JCTree.JCExpression fType = field.vartype;
            JCTree.JCFieldAccess thisDotField = maker.Select((JCTree.JCExpression)maker.Ident(thisName), field.name);
            JCTree.JCFieldAccess otherDotField = maker.Select((JCTree.JCExpression)maker.Ident(otherName), field.name);
            if (fType instanceof JCTree.JCPrimitiveTypeTree) {
                switch (((JCTree.JCPrimitiveTypeTree)fType).getPrimitiveTypeKind()) {
                    case FLOAT: {
                        statements = statements.append(this.generateCompareFloatOrDouble(thisDotField, otherDotField, maker, typeNode, false));
                        continue block5;
                    }
                    case DOUBLE: {
                        statements = statements.append(this.generateCompareFloatOrDouble(thisDotField, otherDotField, maker, typeNode, true));
                        continue block5;
                    }
                }
                statements = statements.append(maker.If(maker.Binary(61, thisDotField, otherDotField), this.returnBool(maker, false), null));
                continue;
            }
            if (fType instanceof JCTree.JCArrayTypeTree) {
                boolean multiDim = ((JCTree.JCArrayTypeTree)fType).elemtype instanceof JCTree.JCArrayTypeTree;
                boolean primitiveArray = ((JCTree.JCArrayTypeTree)fType).elemtype instanceof JCTree.JCPrimitiveTypeTree;
                boolean useDeepEquals = multiDim || !primitiveArray;
                JCTree.JCExpression eqMethod = JavacHandlerUtil.chainDots(maker, typeNode, "java", "util", "Arrays", useDeepEquals ? "deepEquals" : "equals");
                List<JCTree.JCExpression> args = List.of(thisDotField, otherDotField);
                statements = statements.append(maker.If(maker.Unary(48, maker.Apply(List.<JCTree.JCExpression>nil(), eqMethod, args)), this.returnBool(maker, false), null));
                continue;
            }
            JCTree.JCBinary thisEqualsNull = maker.Binary(60, thisDotField, maker.Literal(17, null));
            JCTree.JCBinary otherNotEqualsNull = maker.Binary(61, otherDotField, maker.Literal(17, null));
            JCTree.JCMethodInvocation thisEqualsThat = maker.Apply(List.<JCTree.JCExpression>nil(), maker.Select((JCTree.JCExpression)thisDotField, typeNode.toName("equals")), List.of(otherDotField));
            JCTree.JCConditional fieldsAreNotEqual = maker.Conditional(thisEqualsNull, otherNotEqualsNull, maker.Unary(48, thisEqualsThat));
            statements = statements.append(maker.If(fieldsAreNotEqual, this.returnBool(maker, false), null));
        }
        statements = statements.append(this.returnBool(maker, true));
        JCTree.JCBlock body = maker.Block(0L, statements);
        return maker.MethodDef(mods, typeNode.toName("equals"), returnType, List.<JCTree.JCTypeParameter>nil(), params, List.<JCTree.JCExpression>nil(), body, null);
    }

    private JCTree.JCStatement generateCompareFloatOrDouble(JCTree.JCExpression thisDotField, JCTree.JCExpression otherDotField, TreeMaker maker, JavacNode node, boolean isDouble) {
        JCTree.JCExpression clazz = JavacHandlerUtil.chainDots(maker, node, "java", "lang", isDouble ? "Double" : "Float");
        List<JCTree.JCExpression> args = List.of(thisDotField, otherDotField);
        JCTree.JCBinary compareCallEquals0 = maker.Binary(61, maker.Apply(List.<JCTree.JCExpression>nil(), maker.Select(clazz, node.toName("compare")), args), maker.Literal(0));
        return maker.If(compareCallEquals0, this.returnBool(maker, false), null);
    }

    private JCTree.JCStatement returnBool(TreeMaker maker, boolean bool) {
        return maker.Return(maker.Literal(8, bool ? 1 : 0));
    }
}

