/*
 * Decompiled with CFR 0.152.
 */
package lombok.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import lombok.core.AST;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LombokNode<A extends AST<A, L, N>, L extends LombokNode<A, L, N>, N> {
    protected final A ast;
    protected final AST.Kind kind;
    protected final N node;
    protected final List<L> children;
    protected L parent;
    protected boolean handled;
    protected boolean isStructurallySignificant;

    protected LombokNode(A ast, N node, List<L> children, AST.Kind kind) {
        this.ast = ast;
        this.kind = kind;
        this.node = node;
        this.children = children == null ? new ArrayList() : children;
        for (LombokNode child : this.children) {
            child.parent = this;
        }
        this.isStructurallySignificant = this.calculateIsStructurallySignificant();
    }

    public String toString() {
        return String.format("NODE %s (%s) %s%s", new Object[]{this.kind, this.node == null ? "(NULL)" : this.node.getClass(), this.handled ? "[HANDLED]" : "", this.node == null ? "" : this.node});
    }

    public String getPackageDeclaration() {
        return ((AST)this.ast).getPackageDeclaration();
    }

    public Collection<String> getImportStatements() {
        return ((AST)this.ast).getImportStatements();
    }

    protected abstract boolean calculateIsStructurallySignificant();

    public L getNodeFor(N obj) {
        return ((AST)this.ast).get(obj);
    }

    public N get() {
        return this.node;
    }

    public L replaceWith(N newN, AST.Kind newNodeKind) {
        ((AST)this.ast).setChanged();
        Object newNode = ((AST)this.ast).buildTree(newN, newNodeKind);
        ((LombokNode)newNode).parent = this.parent;
        for (int i = 0; i < ((LombokNode)this.parent).children.size(); ++i) {
            if (((LombokNode)this.parent).children.get(i) != this) continue;
            ((LombokNode)this.parent).children.set(i, newNode);
        }
        ((LombokNode)this.parent).replaceChildNode(this.get(), newN);
        return newNode;
    }

    public void replaceChildNode(N oldN, N newN) {
        ((AST)this.ast).setChanged();
        ((AST)this.ast).replaceStatementInNode(this.get(), oldN, newN);
    }

    public AST.Kind getKind() {
        return this.kind;
    }

    public abstract String getName();

    public L up() {
        L result = this.parent;
        while (result != null && !((LombokNode)result).isStructurallySignificant) {
            result = ((LombokNode)result).parent;
        }
        return result;
    }

    public L directUp() {
        return this.parent;
    }

    public Collection<L> down() {
        return new ArrayList<L>(this.children);
    }

    public boolean isHandled() {
        return this.handled;
    }

    public L setHandled() {
        this.handled = true;
        return (L)this;
    }

    public L top() {
        return ((AST)this.ast).top();
    }

    public String getFileName() {
        return ((AST)this.ast).getFileName();
    }

    public L add(N newChild, AST.Kind newChildKind) {
        ((AST)this.ast).setChanged();
        Object n = ((AST)this.ast).buildTree(newChild, newChildKind);
        if (n == null) {
            return null;
        }
        ((LombokNode)n).parent = this;
        this.children.add(n);
        return n;
    }

    public void rebuild() {
        IdentityHashMap oldNodes = new IdentityHashMap();
        this.gatherAndRemoveChildren(oldNodes);
        Object newNode = ((AST)this.ast).buildTree(this.get(), this.kind);
        ((AST)this.ast).setChanged();
        ((AST)this.ast).replaceNewWithExistingOld(oldNodes, newNode);
    }

    private void gatherAndRemoveChildren(Map<N, L> map) {
        for (LombokNode child : this.children) {
            child.gatherAndRemoveChildren(map);
        }
        ((AST)this.ast).identityDetector.remove(this.get());
        map.put(this.get(), this);
        this.children.clear();
        ((AST)this.ast).getNodeMap().remove(this.get());
    }

    public void removeChild(L child) {
        ((AST)this.ast).setChanged();
        this.children.remove(child);
    }

    public L recursiveSetHandled() {
        this.handled = true;
        for (LombokNode child : this.children) {
            child.recursiveSetHandled();
        }
        return (L)this;
    }

    public abstract void addError(String var1);

    public abstract void addWarning(String var1);

    public boolean isStructurallySignificant() {
        return this.isStructurallySignificant;
    }
}

