/*
 * Decompiled with CFR 0.152.
 */
package lombok.installer.netbeans;

import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import lombok.installer.CorruptedIdeLocationException;
import lombok.installer.IdeFinder;
import lombok.installer.IdeLocation;
import lombok.installer.IdeLocationProvider;
import lombok.installer.netbeans.NetbeansLocation;

public class NetbeansLocationProvider
implements IdeLocationProvider {
    public IdeLocation create(String path) throws CorruptedIdeLocationException {
        return NetbeansLocationProvider.create0(path);
    }

    static NetbeansLocation create0(String path) throws CorruptedIdeLocationException {
        if (path == null) {
            throw new NullPointerException("path");
        }
        File p = new File(path);
        if (!p.exists()) {
            return null;
        }
        if (p.isDirectory()) {
            File conf;
            String name = p.getName().toLowerCase();
            if (name.endsWith(".app") && name.startsWith("netbeans") && (conf = new File(p, "Contents/Resources/NetBeans/etc/netbeans.conf")).exists()) {
                return new NetbeansLocation(path, conf);
            }
            File f = new File(p, "bin/netbeans");
            if (f.isFile()) {
                return NetbeansLocationProvider.findNetbeansConfFromExe(f, 0);
            }
            f = new File(p, "bin/netbeans.exe");
            if (f.isFile()) {
                return NetbeansLocationProvider.findNetbeansConfFromExe(f, 0);
            }
            f = new File(p, "etc/netbeans.conf");
            if (f.isFile()) {
                return new NetbeansLocation(IdeLocation.canonical(f.getParentFile().getParentFile()), f);
            }
        }
        if (p.isFile()) {
            if (p.getName().equalsIgnoreCase("netbeans.conf")) {
                return new NetbeansLocation(IdeLocation.canonical(p.getParentFile().getParentFile()), p);
            }
            if (p.getName().equalsIgnoreCase("netbeans") || p.getName().equalsIgnoreCase("netbeans.exe")) {
                return NetbeansLocationProvider.findNetbeansConfFromExe(p, 0);
            }
        }
        return null;
    }

    private static NetbeansLocation findNetbeansConfFromExe(File exePath, int loopCounter) throws CorruptedIdeLocationException {
        File conf = new File(exePath.getParentFile(), "etc/netbeans.conf");
        if (conf.isFile()) {
            return new NetbeansLocation(IdeLocation.canonical(exePath), conf);
        }
        conf = new File(exePath.getParentFile().getParentFile(), "etc/netbeans.conf");
        if (conf.isFile()) {
            return new NetbeansLocation(IdeLocation.canonical(exePath), conf);
        }
        if (loopCounter < 50) {
            try {
                String oPath = exePath.getAbsolutePath();
                String nPath = exePath.getCanonicalPath();
                if (!oPath.equals(nPath)) {
                    try {
                        return NetbeansLocationProvider.findNetbeansConfFromExe(new File(nPath), loopCounter + 1);
                    }
                    catch (CorruptedIdeLocationException ignore) {}
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public Pattern getLocationSelectors(IdeFinder.OS os) {
        switch (os) {
            case MAC_OS_X: {
                return Pattern.compile("^(netbeans|netbeans\\.conf|NetBeans.*\\.app)$", 2);
            }
            case WINDOWS: {
                return Pattern.compile("^(netbeans\\.exe|netbeans\\.conf)$", 2);
            }
        }
        return Pattern.compile("^(netbeans|netbeans\\.conf)$", 2);
    }
}

