/*
 * Decompiled with CFR 0.152.
 */
package com.ociweb.example.domain;

import com.ociweb.example.domain.Order;
import com.ociweb.example.domain.ShippingOrder;
import com.ociweb.example.domain.Warehouse;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;

public class OrderSite {
    private Warehouse warehouse;

    public void process(Order order) {
        ShippingOrder shippingOrder = new ShippingOrder().forPurchase(order);
        shippingOrder.shipsOn(this.calculateShippingDate(shippingOrder));
        this.warehouse.shipProduct(shippingOrder);
    }

    private DateMidnight calculateShippingDate(ShippingOrder shippingOrder) {
        return shippingOrder.getQuantity() < 10 ? this.oneDayFromNow() : this.threeDaysFromNow();
    }

    private DateMidnight oneDayFromNow() {
        return new DateTime().plusDays(1).toDateMidnight();
    }

    private DateMidnight threeDaysFromNow() {
        return new DateTime().plusDays(3).toDateMidnight();
    }

    public void setWarehouse(Warehouse warehouse) {
        this.warehouse = warehouse;
    }
}

