/*
 * Decompiled with CFR 0.152.
 */
package com.ociweb.example.routes;

import com.ociweb.example.domain.ShippingOrder;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;

public class WarehouseRoute
extends RouteBuilder {
    public void configure() {
        ((ChoiceDefinition)this.from("warehouse").choice().when(this.quantityIsGreaterThan(200)).to("bean:bulkOrderWarehouse")).otherwise().to("bean:sprocketWarehouse");
    }

    private Predicate quantityIsGreaterThan(final int bulkQuantity) {
        return new Predicate(){

            public boolean matches(Exchange exchange) {
                return ((ShippingOrder)exchange.getIn().getBody(ShippingOrder.class)).getQuantity() >= bulkQuantity;
            }
        };
    }
}

