package com.ociweb.jnb.apr2010;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Sets;

import java.util.Set;

public class ExerciseComparisonChain {

    static class Person implements Comparable {
        private int birthMonth;
        private int birthDayOfWeek;
        private int birthYear;
        private String firstName;

        Person(String firstName, int birthMonth, int birthDayOfWeek, int birthYear) {
            this.birthMonth = birthMonth;
            this.birthDayOfWeek = birthDayOfWeek;
            this.birthYear = birthYear;
            this.firstName = firstName;
        }

        public int compareTo(Object o) {
            Person other = (Person) o;
            return ComparisonChain.start().
                    compare(birthYear, other.birthYear).
                    compare(birthMonth, other.birthMonth).
                    compare(birthDayOfWeek, other.birthDayOfWeek).
                    compare(firstName, other.firstName).
                    result();
        }
    }

    public static void main(String[] args) {
        Set<Person> people = Sets.newTreeSet();
        people.add(new Person("Abigail", 4, 1, 1980));
        people.add(new Person("Courtney", 5, 2, 1981));
        people.add(new Person("Chastity", 5, 2, 1981));
        for (Person person : people) {
            System.out.println(person.firstName);
        }
    }
}
