package com.ociweb.jnb.apr2010;

import com.google.common.util.concurrent.AbstractCheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;

import java.util.concurrent.*;

public class ExerciseAbstractCheckedFuture<V> extends AbstractCheckedFuture<V, ExerciseAbstractCheckedFuture.CustomException> {

    public ExerciseAbstractCheckedFuture(ListenableFuture<V> delegate) {
        super(delegate);
    }

    @Override
    protected CustomException mapException(Exception e) {
        return new CustomException(e);
    }

    public static class CustomException extends Exception {
        public CustomException(Throwable cause) {
            super(cause);
        }
    }

    public static void main(String[] args) {
        final Callable<Long> callable = new Callable<Long>() {
            public Long call() throws Exception {
                if (System.currentTimeMillis() % 2 == 0) {
                    throw new RuntimeException();
                }
                return 100L;
            }
        };
        final ExecutorService executorService = Executors.newSingleThreadExecutor();
        final Future<Long> future = executorService.submit(callable);
        final ExerciseAbstractCheckedFuture<Long> checkedFuture = new ExerciseAbstractCheckedFuture<Long>(Futures.makeListenable(future));
        try {
            final long value = checkedFuture.checkedGet();
            System.out.println("value=" + value);
        } catch (CustomException e) {
            e.printStackTrace();
        }
        executorService.shutdown();
    }
}
