package com.ociweb.jnb.apr2010;

import com.google.common.base.Throwables;
import com.google.common.io.Closeables;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ExerciseCloseables {
    public static void main(String[] args) {
        final OutputStream outputStream = newTempFileOutputStream();
        Closeables.closeQuietly(outputStream);
    }
    
    private static OutputStream newTempFileOutputStream() {
        try {
            final File tmpFile = File.createTempFile(ExerciseCloseables.class.getName(), "tmp");
            return new FileOutputStream(tmpFile);
        } catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }
}
