package com.ociweb.jnb.may2010;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class ImplementedCoin {

    private static final String BAZ = "baz";

    private void stringSwitch() {
        final String bar = "bar";
        String key = "key";
        switch (key) {
            case "": {
                System.out.println("Nothing");
                break;
            }
            case "foo": // fallthrough works as before
            case bar:   // local final variables are ok
            case BAZ: { // constants are ok
                System.out.println("Matched key");
                break;
            }
            default:
                break;
        }
    }


/*
    private void illegalStringSwitch() {
        String foo = "foo";
        String key = "key";
        switch (key) {
            case foo:   // local non-final variables are illegal
            case getStringValue(): { // method calls are illegal
                System.out.println("illegal");
                break;
            }
            default:
                break;
        }
    }

    private String getStringValue() {
        return "";
    }
*/

    private void previousInference() {
        List<String> list1 = Arrays.asList("foo", "bar"); // inference
        List<String> list2 = Collections.emptyList(); // inference
        List<String> list3 = new ArrayList<String>(); // no inference
    }


    private void compareInference() {
        AtomicReference<Map<String, List<Integer>>> ref1 =
                new AtomicReference<>();
        AtomicReference<Map<String, List<Integer>>> ref2 =
                new AtomicReference<Map<String, List<Integer>>>();
    }

    private void binaryLiteral() {
        // These all represent the decimal value 43:
        int decimal = 43;
        int hex = 0x2B;
        int octal = 053;
        int binary = 0b101011;
    }

    private void underscores() {
        int phoneNumber = 555_1212;
        long creditCardNumber = 1234_5678_9012_3456L;
        long socialSecurityNumbers = 999_99_9999L;
        float monetaryAmount = 12_345_132.12f;
        long hexBytes = 0xFF_EC_DE_5E;
        long hexWords = 0xFFEC_DE5E;
        long maxLong = 0x7fff_ffff_ffff_ffffL;
        long alsoMaxLong = 9_223_372_036_854_775_807L;

        byte nybbles = 0b0010_0101;
        long bytes = 0b11010010_01101001_10010100_10010010;
        int weirdBitfields = 0b000_10_101;
    }

    private void weirdMethod() {
        int #"weird variable name" = 6;
        int #"funky variable name" = 9;
        System.out.println(#"weird variable name" * #"funky variable name");
    }

}
