package com.ociweb.jnb.may2010;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UnimplementedCoin {

    static String readFirstLineFromFile1(String path) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(path));
        try {
            return br.readLine();
        } finally {
            br.close();
        }
    }

    static String readFirstLineFromFile2(String path) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(path));
        try {
            return br.readLine();
        } finally {
            try {
                br.close();
            } catch (IOException e) {
                e.printStackTrace(); // or log or ignore
            }
        }
    }

    
    static String readFirstLineFromFile3(String path) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(path));
        boolean success = false;
        try {
            String line = br.readLine();
            success = true;
            return line;
        } finally {
            try {
                br.close();
            } catch (IOException e) {
                if (success) {
                    throw e; // propagate original exception
                }
                e.printStackTrace(); // or log or ignore
            }
        }
    }
    
    
    static String readFirstLineFromFile4(String path) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(path)) {
            return br.readLine();
        }
    }
    
    
    static String readFirstLineFromFile5(String path) throws IOException {
        try (Reader fin = new FileReader(file);
            BufferedReader br = new BufferedReader(fin) {
            return br.readLine();
        }
    }
    
    private void varags() {
        List<String> list1 = Arrays.asList("foo");
        // Warning: "unchecked generic array creation
        // for varargs parameter of type ArrayList<String>[]"
        List<ArrayList<String>> list2 =
                Arrays.asList(new ArrayList<String>());
    }
    
    
    private void oldInitializers() {
        final List<String> bridgeSuitOrder =
                Collections.unmodifiableList(
                        Arrays.asList("Clubs", "Diamonds", "Hearts",
                                "Spades", "No Trump"));
        final Set<String> originalStates =
                Collections.unmodifiableSet(
                        new HashSet<String>(
                                Arrays.asList("NH", "MA", "RI", "CT",
                                        "NY", "NJ", "PA", "DE", "MD",
                                        "VA", "NC", "SC", "GA")));
        HashMap<String, Double> weights = new HashMap<String, Double>();
        weights.put("H", 1.0079);
        weights.put("He", 4.0026);
        weights.put("Li", 6.941);
        weights.put("Be", 9.0122);
        weights.put("B", 10.811);
        weights.put("C", 12.011);
        final Map<String, Double> atomicWeights =
                Collections.unmodifiableMap(weights);
    }

    private void newInitializers() {
        final List<String> bridgeSuitOrder =
            ["Clubs", "Diamonds", "Hearts", "Spades", "No Trump"];
        final Set<String> originalStates =
            {"NH", "MA", "RI", "CT", "NY", "NJ", "PA", "DE", "MD",
                "VA", "NC", "SC", "GA"};
        final Map<String, Double> atomicWeights =
            { "H" : 1.0079, "He" : 4.0026, "Li" : 6.941, "Be" : 9.0122,
                "B" : 10.811, "C" : 12.011};
    }
    
    private void oldIndexing() {
        final List<String> bridgeSuitOrder =
            Arrays.asList("Clubs", "Diamonds", "Hearts", "Spades", "No Trump");
        System.out.println("Highest Suit = " + bridgeSuitOrder.get(0));
    
        HashMap<String, Double> atomicWeights = new HashMap<String, Double>();
        atomicWeights.put("H", 1.0079);
        atomicWeights.put("He", 4.0026);
        atomicWeights.put("Li", 6.941);
        atomicWeights.put("Be", 9.0122);
        atomicWeights.put("B", 10.811);
        atomicWeights.put("C", 12.011);
        System.out.println("Carbon weight = " + atomicWeights.get("C"));
    }
    
    private void newIndexing() {
        final List<String> bridgeSuitOrder =
            ["Clubs", "Diamonds", "Hearts", "Spades", "No Trump"];
        System.out.println("Highest Suit = " + bridgeSuitOrder[0]);
    
        final Map<String, Double> atomicWeights =
            { "H" : 1.0079, "He" : 4.0026, "Li" : 6.941, "Be" : 9.0122,
                "B" : 10.811, "C" : 12.011};
        System.out.println("Carbon weight = " + atomicWeights["C"]);
    }
    
}
