package com.ociweb.jnb.jun2010.jbtrek;

import javax.swing.*;
import java.awt.*;

/**
 * User: tfdalt
 * Date: May 14, 2010
 * Time: 7:45:31 PM
 */
public class Main implements Runnable {
    private final String        user;
    private final UserService   userService;


    public Main(UserService userService, String user) {
        this.userService = userService;
        this.user = user;
    }

    public void run() {
        if (!userService.isUserAuthenticated(user)) {
            JOptionPane.showMessageDialog(null, "You are not authenticated");
            return;
        }
        JOptionPane.showMessageDialog(null, "Press 'OK' to commence retinal scan");
        if (!userService.retinaScanVerification(user)) {
            JOptionPane.showMessageDialog(null, "Retinal Scan FAILED !!");
            return;
        }

        JFrame frame = new JFrame("JBTrek");
        frame.setLayout(new GridLayout(2,2));
        
        frame.add(buildButton(Enablement.ENGAGE_WARP_DRIVE, "Warp Drive", "Engage Warp Drive"));
        frame.add(buildButton(Enablement.HAIL_STARFLEET, "Hail Starfleet", "Hail Starfleet"));
        frame.add(buildButton(Enablement.FIRE_PHOTON_TORPEDO, "Fire Photons", "Fire Photon Torpedo"));
        frame.add(buildButton(Enablement.ACTIVATE_SELF_DESTRUCT, "Self Destruct", "Activate Self Destruct"));

        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.pack();
        frame.setVisible(true);
    }

    public JButton buildButton(Enablement enablement, String buttonText, String buttonTooltip) {
        JButton button = new JButton(buttonText);
        button.setToolTipText(buttonTooltip);
        button.setEnabled(userService.userHasEnablement(user, enablement));
        return button;
    }

    public static void main(String[] args) {
        try {
            EventQueue.invokeAndWait(new Main(new UserServiceImpl(), args.length > 0 ? args[0] : "Chekov"));
        } catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }
}
