package com.ociweb.jnb.jun2010.jbtrek;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/**
 * User: tfdalt
 * Date: May 14, 2010
 * Time: 10:24:41 PM
 */
public class UserServiceImpl implements UserService {
    public final HashMap<String, Set<Enablement>> userEnablements = new HashMap<String, Set<Enablement>>();

    public void createUser(String user, Enablement... enablements) {
        userEnablements.put(user, new HashSet<Enablement>(Arrays.asList(enablements)));
    }

    public UserServiceImpl() {
        createUser("Kirk", Enablement.ENGAGE_WARP_DRIVE, Enablement.HAIL_STARFLEET, Enablement.FIRE_PHOTON_TORPEDO, Enablement.ACTIVATE_SELF_DESTRUCT);
        createUser("Sulu", Enablement.ENGAGE_WARP_DRIVE);
        createUser("Chekov", Enablement.FIRE_PHOTON_TORPEDO);
        createUser("Uhura", Enablement.HAIL_STARFLEET);
    }

    public boolean isUserAuthenticated(String user) {
        return userEnablements.keySet().contains(user);
    }

    public boolean retinaScanVerification(String user) {
        return true; // STUB
    }

    public boolean userHasEnablement(String user, Enablement enablement) {
        return userEnablements.get(user).contains(enablement);
    }
}
