package com.ociweb.jnb.jun2010.scala.bowling 

object ScoreBowlingGame extends (List[Int] => List[Int])  {
  class InvalidPinCountException extends Exception("Invalid Pin Count")

  private def reduce[A,B](ys:A,f:(A => (Option[(B, A)]))): List[B] =
      f(ys) match {
        case Some((x, cont)) => x :: reduce(cont,f)
        case None => Nil
      }

  private def invalidPinCount() = throw(new InvalidPinCountException())

  private def scoreFrame(balls: List[Int]): Option[(Int, List[Int])] = balls match {
    case (x1 :: _) if x1 < 0 || x1 > 10 => invalidPinCount
    case (x1 :: x2 :: _) if x2 < 0 || x2 > 10 || (x1 < 10 && x1 + x2 > 10) => invalidPinCount
    case (x1 :: x2 :: x3 :: rest) if x1 == 10 => Some((x1 + x2 + x3), balls.tail)
    case (x1 :: x2 :: x3 :: rest) if x1 + x2 == 10 => Some((x1 + x2 + x3), balls.tail.tail)
    case (x1 :: x2 :: x3 :: rest) => Some(x1 + x2, balls.tail.tail)
    case (x1 :: x2 :: Nil) if x1 + x2 < 10 => Some(x1 + x2, Nil)
    case _ => None
  }

  private def scoreGame(balls:List[Int]): List[Int] = reduce(balls, scoreFrame _).take(10)

  private def tallyScores(scores:List[Int]) = (scores.foldLeft(List[Int]()){
    case (Nil, x) => List(x)
    case (lst, x) => (x + lst.head) :: lst
  }).reverse

  override def apply(rolls:List[Int]):List[Int] = tallyScores(scoreGame(rolls))
}
