package com.ociweb.jnb.jun2010.scala.bowling

import org.jbehave.scenario.{JUnitScenario}
import org.jbehave.scenario.MostUsefulConfiguration
import org.jbehave.scenario.parser.UnderscoredCamelCaseResolver
import org.jbehave.scenario.reporters.FilePrintStreamFactory
import org.jbehave.scenario.reporters.ScenarioReporterBuilder

import org.jbehave.scenario.reporters.ScenarioReporterBuilder._


class BowlingScenario extends JUnitScenario(new BowlingSteps()) {

  useConfiguration(new MostUsefulConfiguration {
    override def forReportingScenarios =
      new ScenarioReporterBuilder(new FilePrintStreamFactory(classOf[BowlingScenario], new UnderscoredCamelCaseResolver))
              .outputTo("jbehave-reports")
              .`with`(Format.CONSOLE)
              .`with`(Format.TXT)
              .`with`(Format.HTML)
              .`with`(Format.XML)
              .build

  })
}