package com.ociweb.jnb.jun2010.scala.bowling 

import org.jbehave.scenario.steps.Steps
import collection.mutable.ListBuffer
import org.hamcrest.MatcherAssert._
import org.hamcrest.Matchers._
import org.jbehave.scenario.annotations._
import com.ociweb.jnb.jun2010.scala.bowling.ScoreBowlingGame.InvalidPinCountException

class BowlingSteps extends Steps {
  var rolls:ListBuffer[Int] = _
  var scoreResult:Option[Either[InvalidPinCountException, Array[Int]]] = _

  @BeforeScenario
  def resetRolls() {
    rolls = new ListBuffer[Int]()
  }

  @BeforeScenario
  def resultScoreResult() {
    scoreResult = None
  }

  @Given("a strike is bowled")
  def aStrikeIsBowled() {
    rolls += 10
  }

  @Given("an $count count is bowled and spare is made")
  @Alias("a $count count is bowled and spare is made")
  def countIsBowledAndSpare(count:Int) {
    rolls += count
    rolls += (10 - count)
  }

  @Given("an $count count is bowled and only $next are picked")
  @Aliases{val values = Array[String](
   "a $count count is bowled and only $next are picked",
   "an $count count is bowled and only $next is picked",
   "a $count count is bowled and only $next is picked"
  )}
  def countIsBowledAndSomePicked(count:Int, next:Int) {
    rolls += count
    rolls += next
  }

  @Given("an $count count is bowled and none are picked")
  @Alias("a $count count is bowled and none are picked")
  def countIsBowledAndNonePicked(count:Int) {
    countIsBowledAndSomePicked(count, 0)
  }

  @Given("an $count count is bowled")
  @Alias("a $count count is bowled")
  def countIsBowled(count:Int) {
    rolls += count
  }

  @Then("the score at frame $frame should be $score")
  @Alias("$score the score at frame $frame should be")
  def scoreAtFrame(@Named("frame") frame:Int, @Named("score") score:Int) {
    assertThat(scoreResult.isEmpty, not(is(true)))
    assertThat(scoreResult.get.isRight, is(true))
    assertThat(scoreResult.get.right.get(frame - 1), is(score))
  }

  @Then("there should be no score at frame $frame")
  def noScoreAtFrame(frame: Int) {
    assertThat(!scoreResult.isEmpty && scoreResult.get.isRight && (scoreResult.get.right.get.length < frame), is(true))
  }

  @Then("invalid pin count should be detected")
  def invalidPinCountShouldBeDetected() {
    assertThat(scoreResult.isEmpty, not(is(true)))
    assertThat(scoreResult.get.isLeft, is(true))
    assertThat(scoreResult.get.left.get, not(nullValue[Exception]))
  }

  @When("scores are tallied")
  def scoreAreTallied {
    try {
      scoreResult = Some(Right(ScoreBowlingGame(rolls.toList).toArray))
    } catch {
      case ex: InvalidPinCountException => {
       scoreResult = Some(Left(ex))
      }
    }
  }

  @Given ("rolls look like $rolls")
  @Alias("rolls are <rolls>")
  def rollsLookLike(@Named("rolls") rollString: String): Unit = {
    rolls = new ListBuffer[Int]
    var rollChars = rollString.toCharArray
    var lastRoll:Option[Int] = None
    rollString.foreach { roll =>
      if (roll == 'X') {
            lastRoll = Some(10)
      } else if (roll >= '0' && roll <= '9') {
            lastRoll = Some(roll - 48)
      } else if (roll == '/') {
            lastRoll = Some(10 - lastRoll.getOrElse(0))
      } else if (roll == '-') {
            lastRoll = Some(0)
      } else {
            lastRoll = None
      }
      lastRoll.foreach(rolls.append(_))
    }
  }

  @Then("scores should be <scores>")
  def scoreShouldBe(@Named("scores") expectedScores: String): Unit = {
    var scoreArray = expectedScores.split(" +")
    assertThat(scoreResult.get.right.get.length, is(scoreArray.length))
    (0 to scoreArray.size-1).foreach { index =>
      assertThat(scoreResult.get.right.get(index), is(scoreArray(index).toInt))
    }
  }

  private def fail(reason:String) = throw new AssertionError(reason)
}