/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityTranslator;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.QueryResultsSource;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueryResultsSourceImpl
implements QueryResultsSource {
    private DatastorePb.Cursor cursor;
    private DatastorePb.CompiledCursor compiledCursor;
    private transient boolean moreResults;
    private final ApiProxy.ApiConfig apiConfig;
    private final int chunkSize;
    private final Transaction txn;
    private static final int AT_LEAST_ONE = -1;

    public QueryResultsSourceImpl(ApiProxy.ApiConfig apiConfig, FetchOptions fetchOptions, Transaction txn) {
        this.apiConfig = apiConfig;
        this.chunkSize = fetchOptions.getChunkSize() != null ? fetchOptions.getChunkSize() : -1;
        this.moreResults = false;
        this.txn = txn;
    }

    public List<Entity> loadFromPb(DatastorePb.QueryResult queryResult) {
        this.cursor = queryResult.getCursor();
        return this.processQueryResult(queryResult);
    }

    @Override
    public boolean hasMoreEntities() {
        return this.moreResults;
    }

    private List<Entity> processQueryResult(DatastorePb.QueryResult result) {
        this.moreResults = result.isMoreResults();
        this.compiledCursor = result.hasCompiledCursor() ? result.getCompiledCursor() : null;
        ArrayList<Entity> loadedEntities = new ArrayList<Entity>(result.resultSize());
        for (OnestoreEntity.EntityProto entityProto : result.results()) {
            loadedEntities.add(EntityTranslator.createFromPb(entityProto));
        }
        return loadedEntities;
    }

    @Override
    public List<Entity> getMoreEntities() {
        return this.getMoreEntities(-1);
    }

    @Override
    public List<Entity> getMoreEntities(int numberToLoad) {
        TransactionImpl.ensureTxnActive(this.txn);
        if (this.moreResults) {
            DatastorePb.NextRequest req = new DatastorePb.NextRequest();
            req.getMutableCursor().copyFrom(this.cursor);
            if (numberToLoad < this.chunkSize) {
                numberToLoad = this.chunkSize;
            }
            if (numberToLoad != -1) {
                req.setCount(numberToLoad);
            }
            if (this.compiledCursor != null) {
                req.setCompile(true);
            }
            DatastorePb.QueryResult result = new DatastorePb.QueryResult();
            DatastoreApiHelper.makeSyncCall(this.apiConfig, "Next", req, result);
            return this.processQueryResult(result);
        }
        return Collections.emptyList();
    }

    @Override
    public Cursor getCursor() {
        if (this.compiledCursor != null) {
            return new Cursor(this.compiledCursor);
        }
        return null;
    }
}

