/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.base.GoogleException;
import com.google.appengine.repackaged.com.google.common.base.Throwables;
import com.google.common.annotations.GoogleInternal;

@GoogleInternal
public class GoogleRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private String internalMessage;
    private String externalMessage = "A system error has occurred";

    public GoogleRuntimeException() {
    }

    public GoogleRuntimeException(String internalMessage) {
        super(internalMessage);
        this.setInternalMessage(internalMessage);
    }

    public GoogleRuntimeException(String externalMessage, Throwable t) {
        super(externalMessage, t);
        this.setInternalMessage(Throwables.getStackTraceAsString(t));
        this.setExternalMessage(externalMessage);
    }

    public GoogleRuntimeException(GoogleException e) {
        super(e);
        this.setInternalMessage(e.getInternalMessage());
        this.setExternalMessage(e.getExternalMessage());
    }

    public int getErrorCode() {
        return -999;
    }

    public String getInternalMessage() {
        return this.internalMessage;
    }

    public void setInternalMessage(String s) {
        this.internalMessage = s;
    }

    public String getExternalMessage() {
        return this.externalMessage;
    }

    public void setExternalMessage(String s) {
        this.externalMessage = s;
    }

    public String getMessage() {
        return this.getInternalMessage();
    }
}

