/*
 * Decompiled with CFR 0.152.
 */
package lombok.patcher;

import lombok.NonNull;

public class Hook {
    @NonNull
    private final String classSpec;
    @NonNull
    private final String methodName;
    @NonNull
    private final String methodDescriptor;

    public boolean isConstructor() {
        return "<init>".equals(this.methodName);
    }

    @NonNull
    public String getClassSpec() {
        return this.classSpec;
    }

    @NonNull
    public String getMethodName() {
        return this.methodName;
    }

    @NonNull
    public String getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public String toString() {
        return "Hook(classSpec=" + this.classSpec + ", methodName=" + this.methodName + ", methodDescriptor=" + this.methodDescriptor + ")";
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + (this.classSpec == null ? 0 : this.classSpec.hashCode());
        result = result * 31 + (this.methodName == null ? 0 : this.methodName.hashCode());
        result = result * 31 + (this.methodDescriptor == null ? 0 : this.methodDescriptor.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        Hook other = (Hook)o;
        if (this.classSpec == null ? other.classSpec != null : !this.classSpec.equals(other.classSpec)) {
            return false;
        }
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        return !(this.methodDescriptor == null ? other.methodDescriptor != null : !this.methodDescriptor.equals(other.methodDescriptor));
    }

    public Hook(@NonNull String classSpec, @NonNull String methodName, @NonNull String methodDescriptor) {
        if (classSpec == null) {
            throw new NullPointerException("classSpec");
        }
        if (methodName == null) {
            throw new NullPointerException("methodName");
        }
        if (methodDescriptor == null) {
            throw new NullPointerException("methodDescriptor");
        }
        this.classSpec = classSpec;
        this.methodName = methodName;
        this.methodDescriptor = methodDescriptor;
    }
}

