/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.ImplicitTransactionManagementPolicy;
import com.google.appengine.api.datastore.ReadPolicy;

public final class DatastoreServiceConfig {
    private ImplicitTransactionManagementPolicy implicitTransactionManagementPolicy = ImplicitTransactionManagementPolicy.NONE;
    private ReadPolicy readPolicy = new ReadPolicy(ReadPolicy.Consistency.STRONG);
    private Double deadline;

    private DatastoreServiceConfig() {
    }

    public DatastoreServiceConfig implicitTransactionManagementPolicy(ImplicitTransactionManagementPolicy p) {
        if (p == null) {
            throw new NullPointerException("implicit transaction management policy must not be null");
        }
        this.implicitTransactionManagementPolicy = p;
        return this;
    }

    public DatastoreServiceConfig readPolicy(ReadPolicy readPolicy) {
        if (readPolicy == null) {
            throw new NullPointerException("read policy must not be null");
        }
        this.readPolicy = readPolicy;
        return this;
    }

    public DatastoreServiceConfig deadline(double deadline) {
        if (deadline <= 0.0) {
            throw new IllegalArgumentException("deadline must be > 0, got " + deadline);
        }
        this.deadline = deadline;
        return this;
    }

    public ImplicitTransactionManagementPolicy getImplicitTransactionManagementPolicy() {
        return this.implicitTransactionManagementPolicy;
    }

    public ReadPolicy getReadPolicy() {
        return this.readPolicy;
    }

    public Double getDeadline() {
        return this.deadline;
    }

    public static final class Builder {
        public static DatastoreServiceConfig withImplicitTransactionManagementPolicy(ImplicitTransactionManagementPolicy p) {
            return Builder.withDefaults().implicitTransactionManagementPolicy(p);
        }

        public static DatastoreServiceConfig withReadPolicy(ReadPolicy readPolicy) {
            return Builder.withDefaults().readPolicy(readPolicy);
        }

        public static DatastoreServiceConfig withDeadline(double deadline) {
            return Builder.withDefaults().deadline(deadline);
        }

        public static DatastoreServiceConfig withDefaults() {
            return new DatastoreServiceConfig();
        }

        private Builder() {
        }
    }
}

