/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.ReferenceType;
import com.google.appengine.repackaged.com.google.common.collect.ComputationException;
import com.google.appengine.repackaged.com.google.common.collect.ForwardingConcurrentMap;
import com.google.appengine.repackaged.com.google.common.collect.MapMaker;
import com.google.appengine.repackaged.com.google.common.collect.NullOutputException;
import com.google.appengine.repackaged.com.google.common.collect.UncheckedThrower;
import com.google.common.annotations.GoogleInternal;
import java.io.Serializable;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GoogleInternal
public abstract class ReferenceCache<K, V>
extends ForwardingConcurrentMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final ConcurrentMap<K, V> map;

    @Deprecated
    public ReferenceCache(ReferenceType keyReferenceType, ReferenceType valueReferenceType) {
        MapMaker maker = new MapMaker();
        switch (keyReferenceType) {
            case PHANTOM: {
                throw new IllegalArgumentException("Phantom references are not supported.");
            }
            case SOFT: {
                maker.softKeys();
                break;
            }
            case WEAK: {
                maker.weakKeys();
            }
        }
        switch (valueReferenceType) {
            case PHANTOM: {
                throw new IllegalArgumentException("Phantom references are not supported.");
            }
            case SOFT: {
                maker.softValues();
                break;
            }
            case WEAK: {
                maker.weakValues();
            }
        }
        this.map = maker.makeComputingMap(new FunctionAdapter());
    }

    @Deprecated
    public ReferenceCache() {
        this.map = new MapMaker().makeComputingMap(new FunctionAdapter());
    }

    @Override
    protected ConcurrentMap<K, V> delegate() {
        return this.map;
    }

    @Override
    public V get(Object key) {
        try {
            return this.map.get(key);
        }
        catch (NullOutputException e) {
            return null;
        }
        catch (ComputationException e) {
            UncheckedThrower.throwAsUnchecked(e.getCause());
            throw new AssertionError();
        }
    }

    protected abstract V create(K var1);

    @Deprecated
    public static <K, V> ReferenceCache<K, V> of(ReferenceType keyReferenceType, ReferenceType valueReferenceType, final Function<? super K, ? extends V> function) {
        Preconditions.checkNotNull(function);
        return new ReferenceCache<K, V>(keyReferenceType, valueReferenceType){
            private static final long serialVersionUID = 0L;

            @Override
            protected V create(K key) {
                return function.apply(key);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FunctionAdapter
    implements Function<K, V>,
    Serializable {
        private static final long serialVersionUID = 0L;

        private FunctionAdapter() {
        }

        @Override
        public V apply(K key) {
            return ReferenceCache.this.create(key);
        }
    }
}

