/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import lombok.AccessLevel;
import lombok.core.AST;
import lombok.core.handlers.TransformationsUtil;
import lombok.eclipse.Eclipse;
import lombok.eclipse.EclipseNode;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.ThrowStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseHandlerUtil {
    private EclipseHandlerUtil() {
    }

    public static boolean isPrimitive(TypeReference ref) {
        if (ref.dimensions() > 0) {
            return false;
        }
        return TransformationsUtil.PRIMITIVE_TYPE_NAME_PATTERN.matcher(Eclipse.toQualifiedName(ref.getTypeName())).matches();
    }

    public static int toEclipseModifier(AccessLevel value) {
        switch (value) {
            case MODULE: 
            case PACKAGE: {
                return 0;
            }
            default: {
                return 1;
            }
            case PROTECTED: {
                return 4;
            }
            case PRIVATE: 
        }
        return 2;
    }

    public static boolean nameEquals(char[][] typeName, String string) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (char[] elem : typeName) {
            if (first) {
                first = false;
            } else {
                sb.append('.');
            }
            sb.append(elem);
        }
        return string.contentEquals(sb);
    }

    public static MemberExistsResult fieldExists(String fieldName, EclipseNode node) {
        while (node != null && !(node.get() instanceof TypeDeclaration)) {
            node = (EclipseNode)node.up();
        }
        if (node != null && node.get() instanceof TypeDeclaration) {
            TypeDeclaration typeDecl = (TypeDeclaration)node.get();
            if (typeDecl.fields != null) {
                for (FieldDeclaration def : typeDecl.fields) {
                    char[] fName = def.name;
                    if (fName == null || !fieldName.equals(new String(fName))) continue;
                    EclipseNode existing = (EclipseNode)node.getNodeFor(def);
                    if (existing == null || !existing.isHandled()) {
                        return MemberExistsResult.EXISTS_BY_USER;
                    }
                    return MemberExistsResult.EXISTS_BY_LOMBOK;
                }
            }
        }
        return MemberExistsResult.NOT_EXISTS;
    }

    public static MemberExistsResult methodExists(String methodName, EclipseNode node) {
        return EclipseHandlerUtil.methodExists(methodName, node, true);
    }

    public static MemberExistsResult methodExists(String methodName, EclipseNode node, boolean caseSensitive) {
        while (node != null && !(node.get() instanceof TypeDeclaration)) {
            node = (EclipseNode)node.up();
        }
        if (node != null && node.get() instanceof TypeDeclaration) {
            TypeDeclaration typeDecl = (TypeDeclaration)node.get();
            if (typeDecl.methods != null) {
                for (AbstractMethodDeclaration def : typeDecl.methods) {
                    boolean nameEquals;
                    char[] mName = def.selector;
                    if (mName == null) continue;
                    boolean bl = nameEquals = caseSensitive ? methodName.equals(new String(mName)) : methodName.equalsIgnoreCase(new String(mName));
                    if (!nameEquals) continue;
                    EclipseNode existing = (EclipseNode)node.getNodeFor(def);
                    if (existing == null || !existing.isHandled()) {
                        return MemberExistsResult.EXISTS_BY_USER;
                    }
                    return MemberExistsResult.EXISTS_BY_LOMBOK;
                }
            }
        }
        return MemberExistsResult.NOT_EXISTS;
    }

    public static MemberExistsResult constructorExists(EclipseNode node) {
        while (node != null && !(node.get() instanceof TypeDeclaration)) {
            node = (EclipseNode)node.up();
        }
        if (node != null && node.get() instanceof TypeDeclaration) {
            TypeDeclaration typeDecl = (TypeDeclaration)node.get();
            if (typeDecl.methods != null) {
                for (AbstractMethodDeclaration def : typeDecl.methods) {
                    if (!(def instanceof ConstructorDeclaration) || (def.bits & 0x80) != 0) continue;
                    EclipseNode existing = (EclipseNode)node.getNodeFor(def);
                    if (existing == null || !existing.isHandled()) {
                        return MemberExistsResult.EXISTS_BY_USER;
                    }
                    return MemberExistsResult.EXISTS_BY_LOMBOK;
                }
            }
        }
        return MemberExistsResult.NOT_EXISTS;
    }

    public static EclipseNode getExistingLombokConstructor(EclipseNode node) {
        while (node != null && !(node.get() instanceof TypeDeclaration)) {
            node = (EclipseNode)node.up();
        }
        if (node == null) {
            return null;
        }
        if (node.get() instanceof TypeDeclaration) {
            for (AbstractMethodDeclaration def : ((TypeDeclaration)node.get()).methods) {
                EclipseNode existing;
                if (!(def instanceof ConstructorDeclaration) || (def.bits & 0x80) != 0 || !(existing = (EclipseNode)node.getNodeFor(def)).isHandled()) continue;
                return existing;
            }
        }
        return null;
    }

    public static EclipseNode getExistingLombokMethod(String methodName, EclipseNode node) {
        while (node != null && !(node.get() instanceof TypeDeclaration)) {
            node = (EclipseNode)node.up();
        }
        if (node == null) {
            return null;
        }
        if (node.get() instanceof TypeDeclaration) {
            for (AbstractMethodDeclaration def : ((TypeDeclaration)node.get()).methods) {
                EclipseNode existing;
                char[] mName = def.selector;
                if (mName == null || !methodName.equals(new String(mName)) || !(existing = (EclipseNode)node.getNodeFor(def)).isHandled()) continue;
                return existing;
            }
        }
        return null;
    }

    public static void injectField(EclipseNode type, FieldDeclaration field) {
        TypeDeclaration parent = (TypeDeclaration)type.get();
        if (parent.fields == null) {
            parent.fields = new FieldDeclaration[1];
            parent.fields[0] = field;
        } else {
            FieldDeclaration[] newArray = new FieldDeclaration[parent.fields.length + 1];
            System.arraycopy(parent.fields, 0, newArray, 0, parent.fields.length);
            newArray[parent.fields.length] = field;
            parent.fields = newArray;
        }
        ((EclipseNode)type.add(field, AST.Kind.FIELD)).recursiveSetHandled();
    }

    public static void injectMethod(EclipseNode type, AbstractMethodDeclaration method) {
        TypeDeclaration parent = (TypeDeclaration)type.get();
        if (parent.methods == null) {
            parent.methods = new AbstractMethodDeclaration[1];
            parent.methods[0] = method;
        } else {
            boolean injectionComplete = false;
            if (method instanceof ConstructorDeclaration) {
                for (int i = 0; i < parent.methods.length; ++i) {
                    if (!(parent.methods[i] instanceof ConstructorDeclaration) || (parent.methods[i].bits & 0x80) == 0) continue;
                    EclipseNode tossMe = (EclipseNode)type.getNodeFor(parent.methods[i]);
                    parent.methods[i] = method;
                    if (tossMe != null) {
                        ((EclipseNode)tossMe.up()).removeChild(tossMe);
                    }
                    injectionComplete = true;
                    break;
                }
            }
            if (!injectionComplete) {
                AbstractMethodDeclaration[] newArray = new AbstractMethodDeclaration[parent.methods.length + 1];
                System.arraycopy(parent.methods, 0, newArray, 0, parent.methods.length);
                newArray[parent.methods.length] = method;
                parent.methods = newArray;
            }
        }
        ((EclipseNode)type.add(method, AST.Kind.METHOD)).recursiveSetHandled();
    }

    public static Annotation[] findAnnotations(FieldDeclaration field, Pattern namePattern) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        if (field.annotations == null) {
            return new Annotation[0];
        }
        for (Annotation annotation : field.annotations) {
            char[][] typeName;
            String suspect;
            TypeReference typeRef = annotation.type;
            if (typeRef == null || typeRef.getTypeName() == null || !namePattern.matcher(suspect = new String((typeName = typeRef.getTypeName())[typeName.length - 1])).matches()) continue;
            result.add(annotation);
        }
        return result.toArray(new Annotation[0]);
    }

    public static Statement generateNullCheck(AbstractVariableDeclaration variable, ASTNode source) {
        int pS = source.sourceStart;
        int pE = source.sourceEnd;
        long p = (long)pS << 32 | (long)pE;
        if (EclipseHandlerUtil.isPrimitive(variable.type)) {
            return null;
        }
        AllocationExpression exception = new AllocationExpression();
        Eclipse.setGeneratedBy((ASTNode)exception, source);
        exception.type = new QualifiedTypeReference(Eclipse.fromQualifiedName("java.lang.NullPointerException"), new long[]{p, p, p});
        Eclipse.setGeneratedBy((ASTNode)exception.type, source);
        exception.arguments = new Expression[]{new StringLiteral(variable.name, pS, pE, 0)};
        Eclipse.setGeneratedBy((ASTNode)exception.arguments[0], source);
        ThrowStatement throwStatement = new ThrowStatement((Expression)exception, pS, pE);
        Eclipse.setGeneratedBy((ASTNode)throwStatement, source);
        SingleNameReference varName = new SingleNameReference(variable.name, p);
        Eclipse.setGeneratedBy((ASTNode)varName, source);
        NullLiteral nullLiteral = new NullLiteral(pS, pE);
        Eclipse.setGeneratedBy((ASTNode)nullLiteral, source);
        EqualExpression equalExpression = new EqualExpression((Expression)varName, (Expression)nullLiteral, 18);
        equalExpression.sourceStart = pS;
        equalExpression.sourceEnd = pE;
        Eclipse.setGeneratedBy((ASTNode)equalExpression, source);
        IfStatement ifStatement = new IfStatement((Expression)equalExpression, (Statement)throwStatement, 0, 0);
        Eclipse.setGeneratedBy((ASTNode)ifStatement, source);
        return ifStatement;
    }

    public static MarkerAnnotation makeMarkerAnnotation(char[][] name, ASTNode source) {
        long pos = (long)source.sourceStart << 32 | (long)source.sourceEnd;
        QualifiedTypeReference typeRef = new QualifiedTypeReference(name, new long[]{pos, pos, pos});
        Eclipse.setGeneratedBy((ASTNode)typeRef, source);
        MarkerAnnotation ann = new MarkerAnnotation((TypeReference)typeRef, (int)(pos >> 32));
        ann.sourceEnd = ann.statementEnd = (int)pos;
        ann.declarationSourceEnd = ann.statementEnd;
        Eclipse.setGeneratedBy((ASTNode)ann, source);
        return ann;
    }

    public static List<Integer> createListOfNonExistentFields(List<String> list, EclipseNode type, boolean excludeStandard, boolean excludeTransient) {
        boolean[] matched = new boolean[list.size()];
        for (EclipseNode child : type.down()) {
            int idx;
            if (list.isEmpty()) break;
            if (child.getKind() != AST.Kind.FIELD || excludeStandard && ((((FieldDeclaration)child.get()).modifiers & 8) != 0 || child.getName().startsWith("$")) || excludeTransient && (((FieldDeclaration)child.get()).modifiers & 0x80) != 0 || (idx = list.indexOf(child.getName())) <= -1) continue;
            matched[idx] = true;
        }
        ArrayList<Integer> problematic = new ArrayList<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            if (matched[i]) continue;
            problematic.add(i);
        }
        return problematic;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MemberExistsResult {
        NOT_EXISTS,
        EXISTS_BY_USER,
        EXISTS_BY_LOMBOK;

    }
}

