/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.QueryResultIterator;
import com.google.appengine.api.datastore.QueryResultsSource;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueryResultIteratorImpl
implements QueryResultIterator<Entity> {
    private final PreparedQuery query;
    private final QueryResultsSource resultsSource;
    private final LinkedList<Entity> entityBuffer;
    private final Transaction txn;
    private Cursor cursor = null;
    private int resultsSinceCursorUpdate = 0;

    QueryResultIteratorImpl(PreparedQuery query, List<Entity> prefetchedEntities, QueryResultsSource resultsSource, FetchOptions fetchOptions, Transaction txn) {
        this.query = query;
        this.resultsSource = resultsSource;
        this.entityBuffer = new LinkedList<Entity>(prefetchedEntities);
        this.txn = txn;
        if (fetchOptions.getCompile() == Boolean.TRUE) {
            if (this.entityBuffer.isEmpty()) {
                this.updateCursorFromResultsSource();
            } else {
                Cursor cursor = this.cursor = fetchOptions.getStartCursor() == null ? new Cursor() : new Cursor(fetchOptions.getStartCursor());
                if (fetchOptions.getOffset() != null) {
                    this.resultsSinceCursorUpdate = fetchOptions.getOffset();
                }
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.ensureLoaded();
    }

    @Override
    public Entity next() {
        TransactionImpl.ensureTxnActive(this.txn);
        if (this.ensureLoaded()) {
            ++this.resultsSinceCursorUpdate;
            return this.entityBuffer.removeFirst();
        }
        throw new NoSuchElementException();
    }

    private void updateCursorFromResultsSource() {
        this.cursor = this.resultsSource.getCursor();
        this.resultsSinceCursorUpdate = 0;
    }

    @Override
    public Cursor getCursor() {
        if (this.entityBuffer.isEmpty()) {
            this.updateCursorFromResultsSource();
        } else if (this.cursor != null) {
            this.cursor.advance(this.resultsSinceCursorUpdate, this.query);
            this.resultsSinceCursorUpdate = 0;
        }
        if (this.cursor != null) {
            return new Cursor(this.cursor);
        }
        return null;
    }

    public List<Entity> nextList(int maximumElements) {
        TransactionImpl.ensureTxnActive(this.txn);
        this.ensureLoaded(maximumElements);
        int numberToReturn = Math.min(maximumElements, this.entityBuffer.size());
        List backingList = this.entityBuffer.subList(0, numberToReturn);
        ArrayList<Entity> returnList = new ArrayList<Entity>(backingList);
        backingList.clear();
        this.resultsSinceCursorUpdate += returnList.size();
        return returnList;
    }

    private boolean ensureLoaded() {
        if (this.entityBuffer.size() <= 0 && this.resultsSource.hasMoreEntities()) {
            this.updateCursorFromResultsSource();
            this.entityBuffer.addAll(this.resultsSource.getMoreEntities());
        }
        return this.entityBuffer.size() > 0;
    }

    private boolean ensureLoaded(int numberDesired) {
        int numberToLoad;
        List<Entity> nextResults;
        this.updateCursorFromResultsSource();
        while (this.resultsSource.hasMoreEntities() && numberDesired > this.entityBuffer.size() && !(nextResults = this.resultsSource.getMoreEntities(numberToLoad = numberDesired - this.entityBuffer.size())).isEmpty()) {
            this.entityBuffer.addAll(nextResults);
        }
        return this.entityBuffer.size() >= numberDesired;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

