#include "TGA.h"

#include <fstream>
void WriteTGA(char *fileName, unsigned short width, unsigned short height, unsigned char *data) {
	#pragma pack(push, 1)
	struct {
		unsigned char  _idLength, _colorMapType, _imageType;
		unsigned short _cMapStart, _cMapLength;
		unsigned char  _cMapDepth;
		unsigned short _xOffset, _yOffset, _width, _height;
		unsigned char  _pixelDepth, _imageDescriptor;
	} tgaHeader;
	#pragma pack(pop)

	memset(&tgaHeader, 0, sizeof(tgaHeader));
	tgaHeader._imageType = 2;
	tgaHeader._width = width;
	tgaHeader._height = height;
	tgaHeader._pixelDepth = 32;
	std::ofstream tga(fileName, std::ios::binary);
	tga.flags(0);
	tga.write((char *)&tgaHeader, sizeof(tgaHeader));
	tga.write((char *)data, width*height*4*sizeof(unsigned char));
}