#include "GPUSupport.h"
#include <math.h>

float length(const float3 &v) {
	return sqrtf(v.x*v.x + v.y*v.y + v.z*v.z);
}

float clamp(float v, float min, float max) {
	if (v<min)
		return min;
	if (v>max)
		return max;
	return v;
}

float3 clamp(const float3 &v, float min, float max) {
	return float3(
		clamp(v.x, min, max),
		clamp(v.y, min, max),
		clamp(v.z, min, max));
}

float3 normalize(const float3 &v) {
	float l = length(v);
	if (l == 0.0)
		return float3(0.0f, 0.0f, 0.0f);
	return float3(v.x/l, v.y/l, v.z/l);
}

float dot(const float3 &a, const float3 &b) {
	return a.x*b.x + a.y*b.y + a.z*b.z;
}


void write_imageui(image2d_t img, int2 pt, uint4 color) {
	img.Set(pt, color);
}