#include <iostream>
#include <omp.h>
#include "GPUSupport.h"
#include "TGA.h"

void Render(image2d_t img, int width, int height, float scale);

int main(int argc, char *argv[]) {
	int width = 512;
	if (argc>=2)
		width = atoi(argv[1]);
	int height = width;
	image2d img(width, height);

	double startTime = omp_get_wtime();
	Render(img, width, height, 3.0f);
	double endTime = omp_get_wtime()-startTime;

	WriteTGA("test.tga", width, height, img.Ptr());
	std::cout << "Calculation time: " << endTime << std::endl;
}