#!/usr/bin/perl

use strict;
use List::Util qw(sum);

sub read_file {
    my $filename = shift;

    my %data = ();

    my ($n,$t);
    open(DATAFILE, "$filename") || die("Cannot open $filename\n");
    while(<DATAFILE>) {
	chomp $_;  # remove command line
	chomp $_;  # remove column headers
	($n,$t) = split(" ", $_);
	print $n . " -> " . $t . "\n";
	$data{$n} = $t;
	print $data{$n} . "\n";
    }

    return %data;
}

# read all data, toss max and min, average remaining, write back out

my $filename = "Sort.txt";
open(DATAFILE, "$filename") || die("Cannot open $filename\n");

my %vstl = ();
my %vomp1 = ();
my %vompn = ();
my %vopenclcpu = ();
my %vopenclgpu = ();

# the data file may start with an empty blank line - delete that first before running this script

for (my $b=0; $b<5; $b++) {
	# read each block
	my $commandline = <DATAFILE>;
	my $headerline = <DATAFILE>;
	
	for (my $i=20; $i<=25; $i++) {

		my $dataline = <DATAFILE>;
		my ($n,$stl,$omp1,$ompn,$openclcpu,$openclgpu) = split(",", $dataline);
		# print $n . " -> " . $stl . ", " . $omp1 . ", " . $ompn . ", " . $openclcpu . ", " . $openclgpu . "\n";
		
		# add to lists
		push(@{$vstl{$n}}, $stl);
		push(@{$vomp1{$n}}, $omp1);
		push(@{$vompn{$n}}, $ompn);
		push(@{$vopenclcpu{$n}}, $openclcpu);
		push(@{$vopenclgpu{$n}}, $openclgpu);
	}
	#my $errorline = <DATAFILE>;  # only include this if the data contains the -61 buffer allocation failure error
	my $blankline = <DATAFILE>;
}


# sort in numerically increasing order, toss highest and lowest, average remaining elements
my %avg_vstl = ();
my %avg_vomp1 = ();
my %avg_vompn = ();
my %avg_vopenclcpu = ();
my %avg_vopenclgpu = ();
foreach my $key (keys %vstl) {
	@{$vstl{$key}} = sort { $a <=> $b } @{$vstl{$key}};
	@{$vstl{$key}} = @{$vstl{$key}}[1..$#{$vstl{$key}}-1];
	$avg_vstl{$key} = sum(@{$vstl{$key}})/@{$vstl{$key}}
}
foreach my $key (keys %vomp1) {
	@{$vomp1{$key}} = sort { $a <=> $b } @{$vomp1{$key}};
	@{$vomp1{$key}} = @{$vomp1{$key}}[1..$#{$vomp1{$key}}-1];
	$avg_vomp1{$key} = sum(@{$vomp1{$key}})/@{$vomp1{$key}}
}	
foreach my $key (keys %vompn) {
	@{$vompn{$key}} = sort { $a <=> $b } @{$vompn{$key}};
	@{$vompn{$key}} = @{$vompn{$key}}[1..$#{$vompn{$key}}-1];
	$avg_vompn{$key} = sum(@{$vompn{$key}})/@{$vompn{$key}}
}		
foreach my $key (keys %vopenclcpu) {
	@{$vopenclcpu{$key}} = sort { $a <=> $b } @{$vopenclcpu{$key}};
	@{$vopenclcpu{$key}} = @{$vopenclcpu{$key}}[1..$#{$vopenclcpu{$key}}-1];
	$avg_vopenclcpu{$key} = sum(@{$vopenclcpu{$key}})/@{$vopenclcpu{$key}}
}		
foreach my $key (keys %vopenclgpu) {
	@{$vopenclgpu{$key}} = sort { $a <=> $b } @{$vopenclgpu{$key}};
	@{$vopenclgpu{$key}} = @{$vopenclgpu{$key}}[1..$#{$vopenclgpu{$key}}-1];
	$avg_vopenclgpu{$key} = sum(@{$vopenclgpu{$key}})/@{$vopenclgpu{$key}}
}

# write results
open FILE, ">avg_stl.dat" or die $!; 
my @keys = keys %avg_vstl;
@keys = sort { $a <=> $b } @keys;  # numeric sort of keys
foreach my $key (@keys) {
    print FILE "$key $avg_vstl{$key}\n";
}
close FILE;

open FILE, ">avg_omp1.dat" or die $!; 
my @keys = keys %avg_vomp1;
@keys = sort { $a <=> $b } @keys;  # numeric sort of keys
foreach my $key (@keys) {
    print FILE "$key $avg_vomp1{$key}\n";
}
close FILE;

open FILE, ">avg_ompn.dat" or die $!; 
my @keys = keys %avg_vompn;
@keys = sort { $a <=> $b } @keys;  # numeric sort of keys
foreach my $key (@keys) {
    print FILE "$key $avg_vompn{$key}\n";
}
close FILE;

open FILE, ">avg_openclcpu.dat" or die $!; 
my @keys = keys %avg_vopenclcpu;
@keys = sort { $a <=> $b } @keys;  # numeric sort of keys
foreach my $key (@keys) {
    print FILE "$key $avg_vopenclcpu{$key}\n";
}
close FILE;

open FILE, ">avg_openclgpu.dat" or die $!; 
my @keys = keys %avg_vopenclgpu;
@keys = sort { $a <=> $b } @keys;  # numeric sort of keys
foreach my $key (@keys) {
    print FILE "$key $avg_vopenclgpu{$key}\n";
}
close FILE;