#ifndef __GPUSUPPORT_H__
#define __GPUSUPPORT_H__

#include <memory>

#define __kernel
#define __write_only
#define __read_only
#define __constant
#define uint unsigned int

template <typename T>
T max(const T& x, const T& y) { return (x>y)?x:y; }


class float3 {
public:
	float x,y,z;

	float3(float v = 0.0f) : x(v), y(v), z(v) {}
	float3(float v1, float v2, float v3) : x(v1), y(v2), z(v3) {}

	float3 &operator+=(float v) {
		x+=v;
		y+=v;
		z+=v;
		return *this;
	}

	float3 &operator+=(const float3 &v) {
		x+=v.x;
		y+=v.y;
		z+=v.z;
		return *this;
	}

	float3 operator*(float v) const {
		return float3(x*v, y*v, z*v);
	}

	float3 operator/(float v) const {
		return float3(x/v, y/v, z/v);
	}

	float3 operator+(const float3 &v) {
		return float3(x+v.x, y+v.y, z+v.z);
	}

	float3 operator-(const float3 &v) {
		return float3(x-v.x, y-v.y, z-v.z);
	}
};


class uint4 {
public:
	uint x,y,z,w;

	uint4(uint v=0) : x(v), y(v), z(v), w(v) {}
	uint4(uint v1, uint v2, uint v3, uint v4) : x(v1), y(v2), z(v3), w(v4) {}
};

class int2 {
public:
	int x,y;

	int2(int v) : x(v), y(v) {}
	int2(int v1, int v2) : x(v1), y(v2) {} 
};


class image2d {
	int _height;
	unsigned char *_ptr;
public: 
    image2d(int width, int height) : _ptr(new unsigned char[width*height*4]), _height(height) {}
	~image2d() { delete _ptr; }
	void Set(const int2 &pt, const uint4 &color) {
		int i = (_height*pt.y+pt.x)*4;
		_ptr[i++] = color.x;
		_ptr[i++] = color.y;
		_ptr[i++] = color.z;
		_ptr[i++] = color.w;
	}
	unsigned char *Ptr() { return _ptr; }
};

typedef image2d& image2d_t;

void write_imageui(image2d_t img, int2 pt, uint4 color);


float length(const float3 &v);
float fabs(float v);
float3 clamp(const float3 &v, float min, float max);
float3 normalize(const float3 &v);
float dot(const float3 &a, const float3 &b);

#endif