package com.ociweb.mongoDB.most;

/*
 * Copyright (c) 2011, Object Computing, Inc.
 * All Rights reserved
 * See the file license.txt for licensing information.
 */
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

/**
 * 
 * simple logging handler without any clutter.
 * 
 * @author Nathan Tippy
 * 
 */
public class SimpleHandler extends Handler {

    private SimpleHandler() {

    }

    @Override
    public void publish(LogRecord record) {
        if (record.getLevel() == Level.SEVERE) {
            System.err.println(record.getMessage());
        } else {
            System.out.println(record.getMessage());
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    public static Logger simpleLoggger(String name) {
        Logger logger = Logger.getLogger(name);
        for (Handler h : logger.getHandlers()) {
            logger.removeHandler(h);
        }
        logger.addHandler(new SimpleHandler());
        logger.setUseParentHandlers(false);
        return logger;
    }

}
