package com.ociweb.mongoDB.most;
/*
 * Copyright (c) 2011, Object Computing, Inc.
 * All Rights reserved
 * See the file license.txt for licensing information.
 */
import com.mongodb.DBObject;


/**
 * Interface for the test data.  A given thread should call for the initial batch and then 
 * use the same array for each update request.  This helps minimize GC while large tests 
 * are running.
 * 
 * @author Nathan Tippy
 *
 */
public interface TestRecordBatchIterator {

    public DBObject[] getInitialBatch();

    public long updateToNextBatch(DBObject[] target);

    public long count();

}
