#include "ImageBuilder.h"
#include <algorithm>

ImageBuilderPtr ImageBuilder::GetImageBuilder(const std::string &fileName) {
	// look at extension, return proper builder
	int i = fileName.find_last_of('.');
	if (i == std::string::npos)
		throw ImageException("File extension not found");
	std::string ext = fileName.substr(i);
	std::transform(ext.begin(), ext.end(),ext.begin(), ::toupper);
	if ((ext == ".JPG") || (ext == ".JPEG"))
		return ImageBuilderPtr(new JPEGBuilder());
	if (ext == ".PNG")
		return ImageBuilderPtr(new PNGBuilder());
	throw ImageException("Unknown file extension");
}

