#ifndef __IMAGELIB_H__
#define __IMAGELIB_H__

#include <stdexcept>
#include <string>

#ifdef WIN32
#ifdef IMAGELIBDLL
    #define EXT_CLASS_IMAGELIB __declspec(dllexport)
#else
    #define EXT_CLASS_IMAGELIB __declspec(dllimport)
#endif
#else
#define EXT_CLASS_IMAGELIB
#endif

class EXT_CLASS_IMAGELIB ImageException : public std::runtime_error {
public:
 ImageException(std::string msg) : std::runtime_error(msg.c_str()) {}
};

typedef void (*ProgressFn)(const std::string &);

#endif
