#include "CommandLine.h"
#include <iostream>
#include <fstream>
#include <math.h>

int main(int argc, char *argv[]) {
	try {
		CommandLine cl(argc, argv);

		int imageWidth = 10000, imageHeight = 10000, tileSize = 256;
		// std::string outputSVG("tiles.html");
        std::string outputSVG("tiles.svg");
		cl.GetOpt("-w", imageWidth);
		cl.GetOpt("-h", imageHeight);
		cl.GetOpt("-s", tileSize);
		cl.GetOpt("-o", outputSVG);
		int overlap = 0;

		std::ofstream out(outputSVG.c_str());
		//out << "<html><body>" << std::endl;

		unsigned int width = (unsigned int)imageWidth;
		unsigned int height = (unsigned int)imageHeight;

		unsigned int maximumLevel = (unsigned int)ceil(log((double)std::max(width, height))/log(2.0));

        double yscale = 0.01;
        double totalheight = 20;
        double totalwidth = 0;
        for (unsigned int level = 0; level <= maximumLevel; level++) {
            double scale = 1.0 / (1 << (maximumLevel - level));
            unsigned int levelWidth = (unsigned int)(ceil(width*scale));
            unsigned int levelHeight = (unsigned int)(ceil(height*scale));
            totalheight += levelHeight*yscale + 20;
            totalwidth = levelWidth + levelWidth/2;
        }

		out << "<svg xmlns='http://www.w3.org/2000/svg' width=\"" << totalwidth*0.05<< "px\" height=\"" << totalheight <<"px\" version=\"1.1\">" << std::endl;

        double transy = 20;  // match totalheight calculation

		for (unsigned int level = 0; level <= maximumLevel; level++) {
			// get the width and height (in pixels) of the current level being processed
			double scale = 1.0 / (1 << (maximumLevel - level));
			unsigned int levelWidth = (unsigned int)(ceil(width*scale));
			unsigned int levelHeight = (unsigned int)(ceil(height*scale));

			// get the number of tiles needed to cover the level dimensions
			unsigned int numTileColumns = (unsigned int)(ceil(levelWidth / (double)tileSize));
			unsigned int numTileRows = (unsigned int)(ceil(levelHeight / (double)tileSize));

            double xshift = levelWidth/2;

            

			out << "<g transform=\"translate(" << (width/2-xshift)*0.05 << "," << transy << ") scale(0.05, " << yscale << ")\">" << std::endl;
            transy += levelHeight*yscale + 20;

            double textxs = 25;
            out << "<text x=\"" << xshift/textxs << "\" y=\"-2\" fill=\"black\" transform=\"scale(" << textxs << ",100)\">" <<
                "Level " << level << ": " << levelWidth << "x" << levelHeight << " (" << numTileColumns << "x" << numTileRows << " tile" << (((numTileColumns>1)||(numTileRows>1))?"s":"") << ")"
                << "</text>" << std::endl;

			out << "<polygon points=\"" << xshift << ",0 " << levelWidth+xshift << ",0 " << levelWidth << "," << levelHeight << " 0," << levelHeight << "\"" <<
  				" style=\"fill:red;stroke:black;stroke-width:1\"/>" << std::endl;

			for (unsigned int row = 0; row < numTileRows; row++) {
				unsigned int tileY = (row == 0) ? 0 : (tileSize * row - overlap);

                // double xs = ((numTileRows-row)/((double)numTileRows)) * xshift;
                double xs = ((levelHeight-tileY)/((double)levelHeight)) * xshift;
				out << "<line x1=\"" << xs << "\" y1=\"" << tileY << "\" x2=\"" << 
					levelWidth+xs << "\" y2=\"" << tileY << "\" style=\"stroke:black;stroke-width:20\"/>" << std::endl;
			}

			for (unsigned int column = 0; column < numTileColumns; column++) {
				unsigned int tileX = (column == 0) ? 0 : (tileSize * column - overlap);

				out << "<line x1=\"" << tileX+xshift << "\" y1=\"0\" x2=\"" << 
					tileX << "\" y2=\"" << levelHeight << "\" style=\"stroke:black;stroke-width:20\"/>" << std::endl;
			}

			out << "</g>" << std::endl;
		}

		out << "</svg>" << std::endl;
		//out << "</body></html>" << std::endl;
	} catch (std::exception &e) {
		std::cout << "Error: " << e.what() << std::endl;
	}

	return 0;	
}
