#include "Crop.h"
#include "ImageBuilder.h"
#include <algorithm>
#include "FileManagement.h"
#include "RowCache.h"
#include <iostream>


// given a source file, crop out a piece and save as a new file
void Crop(RowCache &cache, unsigned int x, unsigned int y, unsigned int width, unsigned int height, const std::string &fileName) {
	// assume Crop() will be called with ascending h for performance as the file is read sequentially

	// if the file is smaller than the crop region, just copy the entire file
	// ** won't work if file types / channel count / channel depth changes
	if ((width>=cache.GetWidth()) && (height>=cache.GetHeight())) {
		FileManagement::Copy(cache.GetFilename(), fileName);
		return;
	}

	ImageWriterPtr writer = ImageBuilder::GetImageBuilder(fileName)->GetWriter();
	writer->Open(fileName, width, height, cache.GetChannelCount(), cache.GetChannelDepth());    // problem if go from PNG->JPEG due to limits

	if (x+width>=cache.GetWidth())
		width=cache.GetWidth()-x;
	if (y+height>=cache.GetHeight())
		height=cache.GetHeight()-y;

	ImageRow destRow = writer->GetImageRow();
	for (unsigned int row = y; row<y+height; row++) {
		ImageRow srcRow = cache.GetRow(row);

		unsigned short r,g,b,a;
		for (unsigned int i=0; i<width; i++) {
			srcRow.GetPixel(i+x, r,g,b,a);
			destRow.SetPixel(i, r,g,b,a);
		}
	
		writer->WriteRow(destRow);
	}
}
