#include "JPEGWriter.h"

void error_exit(j_common_ptr cinfo);

void JPEGWriter::ErrorHandler(j_common_ptr cinfo) {
	j_common_ptr mycinfo = reinterpret_cast<j_common_ptr>(cinfo);

	// get the message
	char buffer[JMSG_LENGTH_MAX];
	(*mycinfo->err->format_message) (mycinfo, buffer);

	// disconnect the error handler so an exception on object cleanup won't disrupt processing of this exception - process is expected to abort()
	mycinfo->err->error_exit = error_exit;

	jpeg_destroy(mycinfo);  // Let the memory manager delete any temp files before we die
	throw ImageException(buffer);
}


void JPEGWriter::Open(const std::string &fileName, unsigned int width, unsigned int height, unsigned int channelCount, unsigned int channelDepth) {
	_width = width;
	_height = height;
	_channelCount = channelCount;
	if (_channelCount != 3)
		throw ImageException("Only RGB color channels are supported for JPEG");  // see J_COLOR_SPACE for other possibilities
	_channelDepth = channelDepth;
	if (_channelDepth != 8)
		throw ImageException("Only 8 bits per channel are supported for JPEG");
	if ((_width>JPEG_MAX_DIMENSION)||(_height>JPEG_MAX_DIMENSION))
		throw ImageException("JPEG image dimensions are too large");

	if (!(_fp=fopen(fileName.c_str(), "wb")))
		throw ImageException(std::string("Could not open ") + fileName + std::string(" for writing"));

	_cinfo.err = jpeg_std_error(&_jerr);  // add my own error handler here - possibly enough to just set err state and return
	_jerr.error_exit = JPEGWriter::ErrorHandler;
	jpeg_create_compress(&_cinfo);

	jpeg_stdio_dest(&_cinfo, _fp);

	_cinfo.image_width = GetWidth(); 	
	_cinfo.image_height = GetHeight();
	_cinfo.input_components = 3;  // more for, e.g., JCS_CMYK but not supported here
	_cinfo.in_color_space = JCS_RGB; 

	int quality = 90;  // out of 100
	jpeg_set_defaults(&_cinfo);
	jpeg_set_quality(&_cinfo, quality, false);  
	// jpeg_set_quality(&cinfo, quality, TRUE);  // limit to baseline-JPEG values 

	jpeg_start_compress(&_cinfo, TRUE);
}


void JPEGWriter::Close() {
	if (_fp) {
		// 6
		jpeg_finish_compress(&_cinfo);

		// 7
		jpeg_destroy_compress(&_cinfo);

		fclose(_fp);
	}
	_fp = 0;
}


void JPEGWriter::WriteRow(const ImageRow &row) {
	unsigned char *p = const_cast<unsigned char *>(row.Get());
	jpeg_write_scanlines(&_cinfo, (JSAMPARRAY)&p, 1);
}




