#include "PNGWriter.h"

void png_cexcept_error(png_structp png_ptr, png_const_charp msg);

void PNGWriter::Open(const std::string &fileName, unsigned int width, unsigned int height, unsigned int channelCount, unsigned int channelDepth) {
	_width = width;
	_height = height;
	_channelCount = channelCount;
	if ((_channelCount != 3) && (_channelCount != 4))
		throw ImageException("Only RGB and RGBA color channels are supported for PNG");
	_channelDepth = channelDepth;
	if ((_channelDepth != 8) && (_channelDepth != 16))
		throw ImageException("Only 8 and 16 bits per channel are supported for PNG");

	if (!(_fp=fopen(fileName.c_str(), "wb")))
		throw ImageException(std::string("Could not open ") + fileName + std::string(" for writing"));

	_png_ptr = png_create_write_struct(PNG_LIBPNG_VER_STRING, NULL, (png_error_ptr)png_cexcept_error, NULL); 
	if (!_png_ptr)
		throw ImageException("png_create_write_struct failed");

	_info_ptr = png_create_info_struct(_png_ptr);
	if (!_info_ptr)
		throw ImageException("png_create_info_struct failed");

	png_init_io(_png_ptr, _fp);

	// 8 or 16, PNG_COLOR_TYPE_RGB or PNG_COLOR_TYPE_RGBA or PNG_COLOR_TYPE_GRAY
	png_set_IHDR(_png_ptr, _info_ptr, width, height, _channelDepth, (_channelCount==3)?PNG_COLOR_TYPE_RGB:PNG_COLOR_TYPE_RGBA, 
		PNG_INTERLACE_NONE, PNG_COMPRESSION_TYPE_BASE, PNG_FILTER_TYPE_BASE);

	png_write_info(_png_ptr, _info_ptr);
}


void PNGWriter::Close() {
	if (_png_ptr) {
		if (_info_ptr) {
			png_write_end(_png_ptr, _info_ptr);
			png_destroy_write_struct(&_png_ptr, &_info_ptr);
		}
		else
			png_destroy_write_struct(&_png_ptr, (png_infopp)NULL);
	}

	if (_fp)
		fclose(_fp);

	_png_ptr = 0;
	_info_ptr = 0;
	_fp = 0;
}


void PNGWriter::WriteRow(const ImageRow &row) {
	png_write_row(_png_ptr, const_cast<unsigned char *>(row.Get()));
}

