#ifndef __ROWCACHE_H__
#define __ROWCACHE_H__

#include "ImageBase.h"
#include <map>
#include <list>

class EXT_CLASS_IMAGELIB RowCache {
protected:
	ImageReaderPtr _reader;
	std::string _fileName;
	unsigned int _maxCacheSize;
	std::map<unsigned int, ImageRow> _rowCache;
	std::list<unsigned int> _mru;
	unsigned int _lastRowRead;

public:
	RowCache(const std::string &fileName, unsigned int maxCacheSize);
	ImageRow GetRow(unsigned int row);
	unsigned int GetWidth() { return _reader->GetWidth(); }
	unsigned int GetHeight() { return _reader->GetHeight(); }
	unsigned int GetChannelCount() const { return _reader->GetChannelCount(); }
	unsigned int GetChannelDepth() const { return _reader->GetChannelDepth(); }
	std::string GetFilename() { return _fileName; }
};

#endif
