#include "CommandLine.h"
#include <algorithm>

CommandLine::CommandLine(int argc, char *argv[]) {
	for (int i = 0; i < argc; i++)
		_cmdLine.push_back(argv[i]);
}

size_t CommandLine::Length() const {
	return _cmdLine.size();
}

bool CommandLine::GetOpt(std::string opt) {
	return std::find(_cmdLine.begin(), _cmdLine.end(), opt) != _cmdLine.end();
}


bool CommandLine::GetOpt(std::string opt, std::string &val) {
  std::vector<std::string>::iterator i = std::find(_cmdLine.begin(), _cmdLine.end(), opt);
	if (i == _cmdLine.end())
		return false;
	i++;
	if (i == _cmdLine.end())
		return false;
	val = *i;
	return true;
}


bool CommandLine::GetOpt(std::string opt, int &val) {
	std::string s;
	if (!GetOpt(opt, s))
		return false;
	val = atoi(s.c_str());
	return true;
}
